/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.filters.tristate;

import io.engineblock.activityapi.cyclelog.buffers.results.ResultReadable;
import io.engineblock.activityapi.cyclelog.filters.tristate.TristateFilter;
import java.util.Arrays;

public class ResultMappingArrayFilter
implements TristateFilter<ResultReadable> {
    private TristateFilter.Policy[] policyResultMap = new TristateFilter.Policy[0];

    public void addPolicy(ResultReadable readable, TristateFilter.Policy defaultPolicy) {
        int result = readable.getResult();
        if (this.policyResultMap.length < result + 1) {
            this.policyResultMap = Arrays.copyOf(this.policyResultMap, result + 1);
        }
        this.policyResultMap[result] = defaultPolicy;
    }

    @Override
    public TristateFilter.Policy apply(ResultReadable readable) {
        int result = readable.getResult();
        if (result > this.policyResultMap.length + 1) {
            throw new RuntimeException("Looking up a cycleResult of " + result + " is not possible with a map array length of " + this.policyResultMap.length);
        }
        return this.policyResultMap[result];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.policyResultMap.length; ++i) {
            sb.append(i).append("->").append((Object)this.policyResultMap[i]).append("\n");
        }
        return sb.toString();
    }

    public TristateFilter.Policy getPolicy(int result) {
        return this.policyResultMap[result];
    }
}

