/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.input;

import io.engineblock.activityapi.cyclelog.buffers.cycles.CycleSegment;
import io.engineblock.activityapi.input.Input;
import java.util.concurrent.atomic.AtomicLong;

public class InputInterval
implements Input {
    private final long min;
    private final long nextMin;
    private AtomicLong next;

    public InputInterval(long min, long nextMin) {
        this.min = min;
        this.nextMin = nextMin;
        this.next = new AtomicLong(min);
    }

    @Override
    public CycleSegment getInputSegment(int segmentLength) {
        int nextCurrent;
        int current;
        do {
            if ((long)(nextCurrent = (current = this.next.intValue()) + segmentLength) <= this.nextMin) continue;
            return null;
        } while (!this.next.compareAndSet(current, nextCurrent));
        return new Segment(current, nextCurrent);
    }

    public String toString() {
        return "InputInterval[" + this.min + "," + this.nextMin + "), next=" + this.next.intValue();
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    public static class Segment
    implements CycleSegment {
        private final long afterEnd;
        private final long start;
        private long next;

        public Segment(long start, long afterEnd) {
            this.start = start;
            this.afterEnd = afterEnd;
            this.next = start;
        }

        @Override
        public long nextCycle() {
            if (this.next < this.afterEnd) {
                return this.next++;
            }
            return -100L;
        }

        @Override
        public boolean isExhausted() {
            return this.next >= this.afterEnd;
        }

        public String toString() {
            return "InputInterval.Segment(" + this.start + "," + this.afterEnd + "]: next=" + this.next;
        }
    }
}

