/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Histogram;
import io.engineblock.metrics.ConvenientSnapshot;
import io.engineblock.metrics.DeltaHdrHistogramReservoir;
import io.engineblock.metrics.DeltaSnapshotReader;
import io.engineblock.metrics.DeltaSnapshotter;
import io.engineblock.metrics.HdrDeltaHistogramAttachment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NicerHistogram
extends Histogram
implements DeltaSnapshotter,
HdrDeltaHistogramAttachment {
    private final DeltaHdrHistogramReservoir hdrDeltaReservoir;
    private long cacheExpiryMillis = 0L;
    private long cacheTimeMillis = 0L;
    private String metricName;
    private List<NicerHistogram> mirrors;

    public NicerHistogram(String metricName, DeltaHdrHistogramReservoir hdrHistogramReservoir) {
        super(hdrHistogramReservoir);
        this.metricName = metricName;
        this.hdrDeltaReservoir = hdrHistogramReservoir;
    }

    @Override
    public DeltaSnapshotReader getDeltaReader() {
        return new DeltaSnapshotReader(this);
    }

    @Override
    public ConvenientSnapshot getSnapshot() {
        if (System.currentTimeMillis() < this.cacheExpiryMillis) {
            return new ConvenientSnapshot(this.hdrDeltaReservoir.getLastSnapshot());
        }
        return new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
    }

    @Override
    public ConvenientSnapshot getDeltaSnapshot(long cacheTimeMillis) {
        this.cacheTimeMillis = cacheTimeMillis;
        this.cacheExpiryMillis = System.currentTimeMillis() + this.cacheTimeMillis;
        ConvenientSnapshot convenientSnapshot = new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
        return convenientSnapshot;
    }

    @Override
    public synchronized NicerHistogram attach() {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<NicerHistogram>();
        }
        DeltaHdrHistogramReservoir mirrorReservoir = this.hdrDeltaReservoir.copySettings();
        NicerHistogram mirror = new NicerHistogram("mirror-" + this.metricName, mirrorReservoir);
        this.mirrors.add(mirror);
        return mirror;
    }

    @Override
    public void update(long value) {
        super.update(value);
        if (this.mirrors != null) {
            for (NicerHistogram mirror : this.mirrors) {
                mirror.update(value);
            }
        }
    }

    @Override
    public org.HdrHistogram.Histogram getNextHdrDeltaHistogram() {
        return this.hdrDeltaReservoir.getNextHdrHistogram();
    }
}

