/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.google.shaded.common.util.concurrent.Uninterruptibles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicRunnable<T extends Runnable>
implements Runnable,
AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(PeriodicRunnable.class);
    private long intervalMillis;
    private T action;
    private Thread thread;
    private volatile boolean running = false;

    public PeriodicRunnable(long intervalMillis, T action) {
        this.action = action;
        this.intervalMillis = intervalMillis;
    }

    public synchronized PeriodicRunnable<T> startDaemonThread() {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName(this.action.toString());
        this.thread.start();
        return this;
    }

    @Override
    public synchronized void close() {
        this.running = false;
        Uninterruptibles.joinUninterruptibly(this.thread);
    }

    public synchronized PeriodicRunnable<T> startMainThread() {
        this.thread = new Thread(this);
        this.thread.setName(this.action.toString());
        this.thread.start();
        return this;
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void run() {
        this.running = true;
        long nextEventTime = System.currentTimeMillis() + this.intervalMillis;
        while (this.running) {
            nextEventTime = this.awaitTime(this.intervalMillis, nextEventTime);
            logger.trace("invoking interval runnable " + this.action);
            this.action.run();
        }
    }

    private long awaitTime(long interval, long nextEventTime) {
        long duration = nextEventTime - System.currentTimeMillis();
        while (System.currentTimeMillis() < nextEventTime) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {}
        }
        return nextEventTime + interval;
    }
}

