/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unit {
    private static final Logger logger = LoggerFactory.getLogger(Unit.class);
    private static Pattern numberFmtPattern = Pattern.compile(" *(?<number>[0-9]+(\\.[0-9]+)?) *(?<unit>[^ ]+?)? *");
    private static long nanoPerSecond = 1000000000L;
    private static long bytesPerGB = 1000000000L;
    private static long BytesPerGiB = 0x40000000L;

    public static Optional<Long> msFor(String duration) {
        return Unit.durationFor(Duration.MS, duration);
    }

    public static Optional<Long> microsecondsFor(String duration) {
        return Unit.durationFor(Duration.US, duration);
    }

    public static Optional<Long> nanosecondsFor(String duration) {
        return Unit.durationFor(Duration.NS, duration);
    }

    public static Optional<Long> secondsFor(String duration) {
        return Unit.durationFor(Duration.SECOND, duration);
    }

    public static Optional<Long> minutesFor(String duration) {
        return Unit.durationFor(Duration.MINUTE, duration);
    }

    public static Optional<Long> durationFor(Duration resultUnit, String spec) {
        Matcher m = numberFmtPattern.matcher(spec);
        if (m.matches()) {
            String numberpart = m.group("number");
            Double base = Double.valueOf(numberpart);
            String unitpart = m.group("unit");
            if (unitpart != null) {
                Duration durationDuration = Duration.valueOfSuffix(unitpart);
                if (durationDuration == null) {
                    throw new RuntimeException("Unable to recognized duration unit:" + unitpart);
                }
                long specnanos = durationDuration.getNanos();
                long resultnanos = resultUnit.getNanos();
                double multiplier = (double)specnanos / (double)resultnanos;
                base = base * multiplier;
            }
            return Optional.of(base.longValue());
        }
        logger.error("Parsing error for specifier: '" + spec + "'");
        return Optional.empty();
    }

    public static Optional<Double> countFor(String spec) {
        return Unit.convertCounts(Count.UNIT, spec);
    }

    public static Optional<Double> convertCounts(Count resultUnit, String spec) {
        Matcher m = numberFmtPattern.matcher(spec);
        if (m.matches()) {
            String numberpart = m.group("number");
            double base = Double.valueOf(numberpart);
            String unitpart = m.group("unit");
            if (unitpart != null) {
                Count specifierUnit = Count.valueOfSuffix(unitpart);
                if (specifierUnit == null) {
                    throw new RuntimeException("Unable to recognized getChainSize unit:" + unitpart);
                }
                double specifierScale = specifierUnit.getMultiplier();
                double resultScale = resultUnit.getMultiplier();
                double multiplier = specifierScale / resultScale;
                base *= multiplier;
            }
            return Optional.of(base);
        }
        logger.error("Parsing error for specifier:'" + spec + "'");
        return Optional.empty();
    }

    public static Optional<Double> bytesFor(String spec) {
        return Unit.convertBytes(Bytes.BYTE, spec);
    }

    public static Optional<Double> convertBytes(Bytes resultUnit, String spec) {
        Matcher m = numberFmtPattern.matcher(spec);
        if (m.matches()) {
            String numberpart = m.group("number");
            double base = Double.valueOf(numberpart);
            String unitpart = m.group("unit");
            if (unitpart != null) {
                Bytes specifierUnit = Bytes.valueOfSuffix(unitpart);
                if (specifierUnit == null) {
                    throw new RuntimeException("Unable to recognized duration unit:" + unitpart);
                }
                long specifierScale = specifierUnit.getBytes();
                long resultScale = resultUnit.getBytes();
                double multiplier = (double)specifierScale / (double)resultScale;
                base *= multiplier;
            }
            return Optional.of(base);
        }
        logger.error("Parsing error for specifier:'" + spec + "'");
        return Optional.empty();
    }

    static /* synthetic */ long access$000() {
        return bytesPerGB;
    }

    static /* synthetic */ long access$100() {
        return BytesPerGiB;
    }

    static /* synthetic */ long access$200() {
        return nanoPerSecond;
    }

    public static enum Duration {
        SECOND("s", "seconds", Unit.access$200()),
        MS("ms", "milliseconds", 1000000L),
        US("\u00b5s", "microseconds", 1000L),
        NS("ns", "nanoseconds", 1L),
        MINUTE("M", "minutes", Unit.access$200() * 60L),
        HOUR("H", "hours", Unit.access$200() * 60L * 60L),
        DAY("D", "days", Unit.access$200() * 60L * 60L * 24L),
        WEEK("W", "weeks", Unit.access$200() * 60L * 60L * 24L * 7L),
        YEAR("Y", "years", Unit.access$200() * 60L * 60L * 24L * 365L);

        private final String name;
        private final String label;
        private final long nanos;

        private Duration(String label, String name, long nanos) {
            this.label = label;
            this.name = name;
            this.nanos = nanos;
        }

        public static Duration valueOfSuffix(String spec) {
            for (Duration duration : Duration.values()) {
                if (duration.label.toLowerCase().equals(spec.toLowerCase())) {
                    return duration;
                }
                if (duration.toString().toLowerCase().equals(spec.toLowerCase())) {
                    return duration;
                }
                if (!duration.name.toLowerCase().equals(spec.toLowerCase())) continue;
                return duration;
            }
            return null;
        }

        public long getNanos() {
            return this.nanos;
        }
    }

    public static enum Bytes {
        BYTE("B", "byte", 1L),
        KB("KB", "kilobyte", 1000L),
        MB("MB", "megabyte", 1000000L),
        GB("GB", "gigabyte", Unit.access$000()),
        TB("TB", "terabyte", Unit.access$000() * 1000L),
        PB("PB", "petabyte", Unit.access$000() * 1000000L),
        EB("EB", "exabyte", Unit.access$000() * Unit.access$000()),
        ZB("ZB", "zettabyte", Unit.access$000() * Unit.access$000() * 1000L),
        YB("YB", "yottabyte", Unit.access$000() * Unit.access$000() * 1000000L),
        KIB("KiB", "kibibyte", 1024L),
        MIB("MiB", "mebibyte", 0x100000L),
        GIB("GiB", "gibibyte", Unit.access$100()),
        TIB("TiB", "tebibyte", Unit.access$100() * 1024L),
        PIB("PIB", "pebibyte", Unit.access$100() * 1024L * 1024L),
        EIB("EiB", "exbibyte", Unit.access$100() * Unit.access$100()),
        ZIB("ZiB", "zebibyte", Unit.access$100() * Unit.access$100() * 1024L),
        YIB("YiB", "yobibyte", Unit.access$100() * Unit.access$100() * 1024L * 1024L);

        private final String name;
        private final long bytes;
        private final String label;

        private Bytes(String label, String name, long bytes) {
            this.label = label;
            this.name = name;
            this.bytes = bytes;
        }

        public static Bytes valueOfSuffix(String unitpart) {
            for (Bytes byteUnit : Bytes.values()) {
                if (byteUnit.label.toLowerCase().equals(unitpart.toLowerCase())) {
                    return byteUnit;
                }
                if (byteUnit.name.toLowerCase().equals(unitpart.toLowerCase())) {
                    return byteUnit;
                }
                if ((byteUnit.name.toLowerCase() + "s").equals(unitpart.toLowerCase())) {
                    return byteUnit;
                }
                if (!byteUnit.toString().toLowerCase().equals(unitpart.toLowerCase())) continue;
                return byteUnit;
            }
            return null;
        }

        public long getBytes() {
            return this.bytes;
        }
    }

    public static enum Count {
        UNIT("U", "unit", 1.0),
        KILO("K", "kilo", 1000.0),
        MEGA("M", "mega", 1000000.0),
        GIGA("G", "giga", 1.0E9),
        TERA("T", "tera", 1.0E12),
        PETA("P", "peta", 1.0E15),
        EXA("E", "exa", 1.0E18);

        private final String label;
        private final String name;
        private final double multiplier;

        private Count(String label, String name, double multiplier) {
            this.label = label;
            this.name = name;
            this.multiplier = multiplier;
        }

        public static Count valueOfSuffix(String suffix) {
            for (Count count : Count.values()) {
                if (count.toString().toLowerCase().equals(suffix.toLowerCase())) {
                    return count;
                }
                if (count.label.toLowerCase().equals(suffix.toLowerCase())) {
                    return count;
                }
                if (!count.name.toLowerCase().equals(suffix.toLowerCase())) continue;
                return count;
            }
            return null;
        }

        public double getMultiplier() {
            return this.multiplier;
        }
    }
}

