/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_bytebuffer;

import io.virtdata.api.ThreadSafeMapper;
import io.virtdata.basicsmappers.from_long.to_long.Hash;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class HashedToByteBuffer
implements LongFunction<ByteBuffer> {
    private final Hash hash;
    private final int length;
    private final int bytes;
    private final int longs;

    public HashedToByteBuffer(int lengthInBytes) {
        this.length = lengthInBytes;
        this.hash = new Hash();
        this.longs = this.length / 8 + 1;
        this.bytes = this.longs * 8;
    }

    @Override
    public ByteBuffer apply(long input) {
        ByteBuffer buffer = ByteBuffer.allocate(this.bytes);
        for (int i = 0; i < this.longs; ++i) {
            long l = this.hash.applyAsLong(input + (long)i);
            buffer.putLong(l);
        }
        buffer.flip();
        return buffer;
    }
}

