/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_long;

import io.virtdata.api.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class CycleRange
implements LongUnaryOperator {
    private final long minValue;
    private final long width;

    public CycleRange(long maxValue) {
        this(0L, maxValue);
    }

    public CycleRange(long minValue, long maxValue) {
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new RuntimeException("CycleRange must have min and max value in that order.");
        }
        this.width = maxValue - minValue;
    }

    @Override
    public long applyAsLong(long operand) {
        return this.minValue + operand % this.width;
    }
}

