/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import com.strobel.reflection.Type;
import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class ResolvedFunction {
    private FunctionType functionType;
    private Object functionObject;
    private DataMapperLibrary library;
    private boolean isThreadSafe;
    public static Comparator<ResolvedFunction> PREFERRED_TYPE_COMPARATOR = new PreferredTypeComparator();

    public ResolvedFunction(Object g, boolean isThreadSafe, DataMapperLibrary library) {
        this.library = library;
        this.functionObject = g;
        this.isThreadSafe = isThreadSafe;
        this.functionType = FunctionType.valueOf(g);
    }

    public ResolvedFunction(Object g, boolean isThreadSafe) {
        this.functionObject = g;
        this.isThreadSafe = isThreadSafe;
        this.functionType = FunctionType.valueOf(g);
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionType functionType) {
        this.functionType = functionType;
    }

    public Object getFunctionObject() {
        return this.functionObject;
    }

    public void setFunctionObject(Object functionObject) {
        this.functionObject = functionObject;
    }

    public DataMapperLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(DataMapperLibrary library) {
        this.library = library;
    }

    public String toString() {
        return "fn:" + this.functionObject.getClass().getCanonicalName() + ", type:" + (Object)((Object)this.functionType) + (this.library == null ? "" : ", lib:" + this.library.getLibraryName());
    }

    public Class<?> getResultClass() {
        Method applyMethod = this.getMethod();
        Type<?> returnType = Type.of(this.functionObject.getClass()).getMethod(applyMethod.getName(), new Type[0]).getReturnType();
        return returnType.getErasedClass();
    }

    public Class<?> getArgType() {
        Method applyMethod = this.getMethod();
        if (applyMethod.getParameterCount() != 1) {
            throw new RuntimeException("The parameter cound is supposed to be 1, but it was" + applyMethod.getParameterCount());
        }
        return applyMethod.getParameterTypes()[0];
    }

    private Method getMethod() {
        Optional<Method> foundMethod = Arrays.stream(this.functionObject.getClass().getMethods()).filter(m -> m.getName().startsWith("apply")).findFirst();
        return foundMethod.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + this.functionObject.getClass().getCanonicalName()));
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    private static class PreferredTypeComparator
    implements Comparator<ResolvedFunction> {
        private PreferredTypeComparator() {
        }

        @Override
        public int compare(ResolvedFunction o1, ResolvedFunction o2) {
            ValueType iv2;
            ValueType iv1 = ValueType.valueOfClass(o1.getArgType());
            int inputComparison = iv1.compareTo(iv2 = ValueType.valueOfClass(o2.getArgType()));
            if (inputComparison != 0) {
                return inputComparison;
            }
            iv1 = ValueType.valueOfClass(o1.getResultClass());
            iv2 = ValueType.valueOfClass(o2.getResultClass());
            return iv1.compareTo(iv2);
        }
    }
}

