/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libimpl.continuous;

import io.virtdata.libimpl.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;

public class RealLongDoubleSampler
implements LongToDoubleFunction {
    private final DoubleUnaryOperator f;
    private ThreadSafeHash hash;

    public RealLongDoubleSampler(DoubleUnaryOperator parentFunc, boolean hash) {
        this.f = parentFunc;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public double applyAsDouble(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unit = (double)value / 9.223372036854776E18;
        double sample = this.f.applyAsDouble(unit);
        return sample;
    }
}

