/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libimpl.discrete;

import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.ValueType;
import io.virtdata.api.specs.SpecData;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.libimpl.discrete.DiscreteIntIntSampler;
import io.virtdata.libimpl.discrete.DiscreteIntLongSampler;
import io.virtdata.libimpl.discrete.DiscreteLongIntSampler;
import io.virtdata.libimpl.discrete.DiscreteLongLongSampler;
import io.virtdata.libimpl.discrete.IntegerDistributionICDSource;
import io.virtdata.libimpl.discrete.InterpolatingIntIntSampler;
import io.virtdata.libimpl.discrete.InterpolatingIntLongSampler;
import io.virtdata.libimpl.discrete.InterpolatingLongIntSampler;
import io.virtdata.libimpl.discrete.InterpolatingLongLongSampler;
import io.virtdata.reflection.ConstructorResolver;
import io.virtdata.reflection.DeferredConstructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.distribution.BinomialDistribution;
import org.apache.commons.math4.distribution.GeometricDistribution;
import org.apache.commons.math4.distribution.HypergeometricDistribution;
import org.apache.commons.math4.distribution.PascalDistribution;
import org.apache.commons.math4.distribution.PoissonDistribution;
import org.apache.commons.math4.distribution.UniformIntegerDistribution;
import org.apache.commons.math4.distribution.ZipfDistribution;

public class IntegerDistributions
implements DataMapperLibrary {
    private static final String MAPTO = "mapto_";
    private static final String HASHTO = "hashto_";
    private static final String COMPUTE = "compute_";
    private static final String INTERPOLATE = "interpolate_";

    public static LongUnaryOperator forSpec(String spec) {
        Optional<ResolvedFunction> resolvedFunction = new IntegerDistributions().resolveFunction(spec);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(f -> (LongUnaryOperator)f).orElseThrow(() -> new RuntimeException("Invalid spec: " + spec));
    }

    private static String distributionNameFor(String specName) {
        return specName.replaceAll(COMPUTE, "").replaceAll(INTERPOLATE, "").replaceAll(MAPTO, "").replaceAll(HASHTO, "");
    }

    @Override
    public String getLibraryName() {
        return "math4-dcurves";
    }

    @Override
    public boolean canParseSpec(String specifier) {
        Optional<SpecData> optionalData = SpecData.forOptionalSpec(specifier);
        if (!optionalData.isPresent()) {
            return false;
        }
        SpecData specData = optionalData.get();
        try {
            String distName = IntegerDistributions.distributionNameFor(specData.getFuncName());
            IntegerDistribution.valueOf(distName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Optional<ResolvedFunction> resolveFunction(String spec) {
        return this.resolveFunction(spec, ValueType.LONG, ValueType.LONG);
    }

    public Optional<ResolvedFunction> resolveFunction(String spec, ValueType inputType, ValueType outputType) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        SpecData specData = SpecData.forSpec(spec);
        String funcName = specData.getFuncName();
        IntegerDistribution integerDistribution = IntegerDistribution.valueOf(IntegerDistributions.distributionNameFor(funcName));
        Class<? extends AbstractIntegerDistribution> distributionClass = integerDistribution.getDistributionClass();
        DeferredConstructor<? extends AbstractIntegerDistribution> deferred = ConstructorResolver.resolve(distributionClass, specData.getArgs());
        AbstractIntegerDistribution distribution = deferred.construct();
        boolean interpolate = !funcName.contains(COMPUTE) || funcName.contains(INTERPOLATE);
        boolean hashto = !funcName.contains(MAPTO) || funcName.contains(HASHTO);
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (inputType == ValueType.LONG && outputType == ValueType.LONG) {
            LongUnaryOperator samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingLongLongSampler(icdSource, 1000, hashto) : new DiscreteLongLongSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        if (inputType == ValueType.INT && outputType == ValueType.LONG) {
            IntToLongFunction samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingIntLongSampler(icdSource, 1000, hashto) : new DiscreteIntLongSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        if (inputType == ValueType.LONG && outputType == ValueType.INT) {
            LongToIntFunction samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingLongIntSampler(icdSource, 1000, hashto) : new DiscreteLongIntSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        if (inputType == ValueType.INT && outputType == ValueType.INT) {
            IntUnaryOperator samplingFunction = null;
            samplingFunction = interpolate ? new InterpolatingIntIntSampler(icdSource, 1000, hashto) : new DiscreteIntIntSampler(icdSource, hashto);
            return Optional.of(new ResolvedFunction(samplingFunction, true));
        }
        return Optional.empty();
    }

    @Override
    public List<ResolvedFunction> resolveFunctions(String specifier) {
        ArrayList<ResolvedFunction> resolvedList = new ArrayList<ResolvedFunction>();
        this.resolveFunction(specifier, ValueType.LONG, ValueType.LONG).map(resolvedList::add);
        this.resolveFunction(specifier, ValueType.LONG, ValueType.INT).map(resolvedList::add);
        this.resolveFunction(specifier, ValueType.INT, ValueType.LONG).map(resolvedList::add);
        this.resolveFunction(specifier, ValueType.INT, ValueType.INT).map(resolvedList::add);
        return resolvedList;
    }

    @Override
    public List<String> getDataMapperNames() {
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(IntegerDistribution.values()).map(String::valueOf).forEach(n -> {
            names.add((String)n);
            names.add(MAPTO + n);
            names.add("mapto_compute_" + n);
            names.add(COMPUTE + n);
        });
        return names;
    }

    private static enum IntegerDistribution {
        hypergeometric(HypergeometricDistribution.class),
        uniform_integer(UniformIntegerDistribution.class),
        geometric(GeometricDistribution.class),
        poisson(PoissonDistribution.class),
        zipf(ZipfDistribution.class),
        binomial(BinomialDistribution.class),
        pascal(PascalDistribution.class);

        private final Class<? extends AbstractIntegerDistribution> distribution;

        private IntegerDistribution(Class<? extends AbstractIntegerDistribution> distribution) {
            this.distribution = distribution;
        }

        public Class<? extends AbstractIntegerDistribution> getDistributionClass() {
            return this.distribution;
        }
    }
}

