/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libraryimpl;

import com.google.common.collect.Sets;
import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.ValueType;
import io.virtdata.api.specs.SpecData;
import io.virtdata.core.AllDataMapperLibraries;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.libraryimpl.FunctionAssembly;
import io.virtdata.libraryimpl.composers.MultiSpecData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposerLibrary
implements DataMapperLibrary {
    private static final String PREAMBLE = "compose ";
    private static final Logger logger = LoggerFactory.getLogger(DataMapperLibrary.class);

    @Override
    public String getLibraryName() {
        return "composer";
    }

    @Override
    public boolean canParseSpec(String spec) {
        return MultiSpecData.forOptionalSpec(PREAMBLE, spec).isPresent();
    }

    @Override
    public List<ResolvedFunction> resolveFunctions(String spec) {
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        resolvedFunction.ifPresent(resolvedFunctions::add);
        return resolvedFunctions;
    }

    @Override
    public Optional<ResolvedFunction> resolveFunction(String specline) {
        final MultiSpecData multiSpecData = MultiSpecData.forSpec(PREAMBLE, specline);
        multiSpecData.getResultType().orElseThrow(() -> new RuntimeException("composed mappers must have a -> type annotation at the end."));
        LinkedList<List<ResolvedFunction>> funcs = new LinkedList<List<ResolvedFunction>>();
        LinkedList inputTypes = new LinkedList();
        inputTypes.add(new HashSet<ValueType>(){
            {
                this.add(multiSpecData.getResultType().get());
            }
        });
        for (int i = multiSpecData.getSpecs().size() - 1; i >= 0; --i) {
            SpecData specData = multiSpecData.getSpecs().get(i);
            LinkedList<ResolvedFunction> nodeFunctions = new LinkedList<ResolvedFunction>();
            for (ValueType valueType : (Set)inputTypes.peekFirst()) {
                String vectoredSpec = specData.forResultType(valueType).getCanonicalSpec();
                List<ResolvedFunction> vectoredFunctions = AllDataMapperLibraries.get().resolveFunctions(vectoredSpec);
                logger.trace("Found " + vectoredFunctions.size() + " vectored functions for " + vectoredSpec);
                if (vectoredFunctions.size() == 0) {
                    logger.warn("Falling back to sloppy conversion matching for " + specData.getCanonicalSpec() + " in " + multiSpecData.getCanonicalSpec() + " since no co-compatible type signatures were found.");
                    vectoredFunctions = AllDataMapperLibraries.get().resolveFunctions(specData.getCanonicalSpec());
                }
                if (vectoredFunctions.size() == 0) {
                    throw new RuntimeException("Unable to find any functions for " + specData.getCanonicalSpec());
                }
                nodeFunctions.addAll(vectoredFunctions);
            }
            funcs.addFirst(nodeFunctions);
            inputTypes.addFirst(new HashSet());
            for (ResolvedFunction resolvedFunction : nodeFunctions) {
                ((Set)inputTypes.peekFirst()).add(resolvedFunction.getFunctionType().getInputValueType());
            }
        }
        if (!((Set)inputTypes.peekFirst()).contains(ValueType.LONG)) {
            throw new RuntimeException("There is no initial function which accepts a long input. Function chain, after type filtering: \n" + this.summarize(funcs));
        }
        ValueType resultType = multiSpecData.getResultType().orElseThrow(() -> new RuntimeException("missing result type specifier"));
        List<ResolvedFunction> flattenedFuncs = this.optimizePath(funcs, resultType);
        FunctionAssembly assembly = new FunctionAssembly();
        boolean isThreadSafe = true;
        for (ResolvedFunction resolvedFunction : flattenedFuncs) {
            assembly.andThen(resolvedFunction.getFunctionObject());
            if (resolvedFunction.isThreadSafe()) continue;
            isThreadSafe = false;
        }
        ResolvedFunction resolvedFunction = assembly.getResolvedFunction(isThreadSafe);
        return Optional.of(resolvedFunction);
    }

    private String summarize(LinkedList<List<ResolvedFunction>> funcs) {
        LinkedList spans = new LinkedList();
        funcs.forEach(l -> spans.add(l.stream().map(String::valueOf).collect(Collectors.toList())));
        List widths = spans.stream().map(l -> l.stream().map(String::length).max(Integer::compare)).collect(Collectors.toList());
        String summary = spans.stream().map(l -> l.stream().map(String::valueOf).collect(Collectors.joining("|\n"))).collect(Collectors.joining("\n"));
        return summary;
    }

    private List<ResolvedFunction> optimizePath(List<List<ResolvedFunction>> funcs, ValueType resultType) {
        List<ResolvedFunction> prevFuncs = null;
        List<ResolvedFunction> nextFuncs = null;
        int progress = -1;
        while (progress != 0) {
            progress = 0;
            progress += this.reduceByResultType(funcs.get(funcs.size() - 1), resultType);
            if (funcs.size() <= 1) continue;
            Iterator<List<ResolvedFunction>> iterator = funcs.iterator();
            while (iterator.hasNext()) {
                List<ResolvedFunction> funcList;
                nextFuncs = funcList = iterator.next();
                if (prevFuncs != null && (progress += this.reduceByDirectTypes(prevFuncs, nextFuncs)) == 0) {
                    progress += this.reduceByPreferredTypes(prevFuncs, nextFuncs);
                }
                prevFuncs = nextFuncs;
            }
        }
        List<ResolvedFunction> optimized = funcs.stream().map(l -> (ResolvedFunction)l.get(0)).collect(Collectors.toList());
        return optimized;
    }

    private int reduceByResultType(List<ResolvedFunction> endFuncs, ValueType resultType) {
        int progressed = 0;
        LinkedList<ResolvedFunction> tmpList = new LinkedList<ResolvedFunction>(endFuncs);
        for (ResolvedFunction endFunc : tmpList) {
            if (!resultType.getValueClass().isAssignableFrom(endFunc.getResultClass())) {
                endFuncs.remove(endFunc);
                logger.trace("removed function '" + endFunc + "' because it does not yield type " + resultType);
                ++progressed;
                continue;
            }
            logger.trace("binding matched");
        }
        if (endFuncs.size() == 0) {
            throw new RuntimeException("No end funcs were found which yield result type " + resultType);
        }
        return progressed;
    }

    private int reduceByPreferredTypes(List<ResolvedFunction> prevFuncs, List<ResolvedFunction> nextFuncs) {
        int progressed;
        block3: {
            block2: {
                progressed = 0;
                if (prevFuncs.size() <= 1) break block2;
                progressed += prevFuncs.size() - 1;
                Collections.sort(prevFuncs, ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
                while (prevFuncs.size() > 1) {
                    logger.trace("removing func " + prevFuncs.get(prevFuncs.size() - 1) + " because " + prevFuncs.get(0) + " has more preferred types.");
                    prevFuncs.remove(prevFuncs.size() - 1);
                }
                break block3;
            }
            if (nextFuncs.size() <= 1) break block3;
            progressed += nextFuncs.size() - 1;
            Collections.sort(nextFuncs, ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
            while (nextFuncs.size() > 1) {
                logger.trace("removing func " + nextFuncs.get(nextFuncs.size() - 1) + " because " + nextFuncs.get(0) + " has more preferred types.");
                nextFuncs.remove(nextFuncs.size() - 1);
            }
        }
        return progressed;
    }

    private int reduceByDirectTypes(List<ResolvedFunction> prevFuncs, List<ResolvedFunction> nextFuncs) {
        int progressed = 0;
        Set<Class<?>> outputs = this.getOutputs(prevFuncs);
        Set<Class<?>> inputs = this.getInputs(nextFuncs);
        Sets.SetView<Class<?>> directMatches = Sets.intersection(inputs, outputs);
        if (directMatches.size() > 0) {
            ArrayList<ResolvedFunction> toremove = new ArrayList<ResolvedFunction>();
            for (ResolvedFunction nextFunc : nextFuncs) {
                if (directMatches.contains(nextFunc.getArgType())) continue;
                logger.debug("removing next func: " + nextFunc + " because its input types are not satisfied by an previous func");
                toremove.add(nextFunc);
                ++progressed;
            }
            nextFuncs.removeAll(toremove);
        }
        return progressed;
    }

    private Set<Class<?>> getOutputs(List<ResolvedFunction> prevFuncs) {
        HashSet outputs = new HashSet();
        for (ResolvedFunction func : prevFuncs) {
            outputs.add(func.getResultClass());
        }
        return outputs;
    }

    private Set<Class<?>> getInputs(List<ResolvedFunction> nextFuncs) {
        HashSet inputs = new HashSet();
        for (ResolvedFunction nextFunc : nextFuncs) {
            inputs.add(nextFunc.getArgType());
        }
        return inputs;
    }

    @Override
    public List<String> getDataMapperNames() {
        ArrayList genNames = new ArrayList();
        return new ArrayList<String>(){
            {
                this.add("compose");
            }
        };
    }
}

