/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libraryimpl.composers;

import io.virtdata.api.ValueType;
import io.virtdata.api.specs.SpecData;
import io.virtdata.api.specs.Specifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MultiSpecData
implements Specifier {
    private final LinkedList<SpecData> specDataList = new LinkedList();
    private String preamble;

    private MultiSpecData(String preamble, List<SpecData> specDataList) {
        this.preamble = preamble;
        this.specDataList.addAll(specDataList);
    }

    public static Optional<MultiSpecData> forOptionalSpec(String preamble, String multispec) {
        String[] split;
        if (!multispec.startsWith(preamble)) {
            return Optional.empty();
        }
        multispec = multispec.substring(preamble.length());
        ArrayList<SpecData> specDataList = new ArrayList<SpecData>();
        for (String s : split = multispec.split("\\s*;\\s*")) {
            Optional<SpecData> sd = SpecData.forOptionalSpec(s);
            if (!sd.isPresent()) {
                return Optional.empty();
            }
            specDataList.add(sd.get());
        }
        MultiSpecData multiSpecData = new MultiSpecData(preamble, specDataList);
        return Optional.of(multiSpecData);
    }

    @Override
    public Optional<ValueType> getResultType() {
        Optional<ValueType> resultType = this.specDataList.getLast().getResultType();
        return resultType;
    }

    @Override
    public String getCanonicalSpec() {
        return this.specDataList.stream().map(SpecData::getCanonicalSpec).collect(Collectors.joining(";"));
    }

    public List<SpecData> getSpecs() {
        return new LinkedList<SpecData>(this.specDataList);
    }

    public static MultiSpecData forSpec(String preamble, String multispec) {
        Optional<MultiSpecData> multiSpecData = MultiSpecData.forOptionalSpec(preamble, multispec);
        return multiSpecData.orElseThrow(() -> new RuntimeException("Unable to parse multispec: " + multispec));
    }
}

