/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErfc;

public class LevyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20630311L;
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double mu, double c) {
        this.mu = mu;
        this.c = c;
        this.halfC = 0.5 * c;
    }

    @Override
    public double density(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return FastMath.sqrt(f / Math.PI) * FastMath.exp(-f) / delta;
    }

    @Override
    public double logDensity(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return 0.5 * FastMath.log(f / Math.PI) - f - FastMath.log(delta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        return Erfc.value(FastMath.sqrt(this.halfC / (x - this.mu)));
    }

    @Override
    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        double t = InverseErfc.value(p);
        return this.mu + this.halfC / (t * t);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    @Override
    public double getNumericalMean() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getNumericalVariance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSupportLowerBound() {
        return this.mu;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

