/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.distribution.IntegerDistribution;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;

public class UniformIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20160308L;
    private final int lower;
    private final int upper;
    private final double upperPlusLower;
    private final double upperMinusLower;

    public UniformIntegerDistribution(int lower, int upper) throws NumberIsTooLargeException {
        if (lower > upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, true);
        }
        this.lower = lower;
        this.upper = upper;
        this.upperPlusLower = (double)upper + (double)lower;
        this.upperMinusLower = (double)upper - (double)lower;
    }

    @Override
    public double probability(int x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upperMinusLower + 1.0);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < this.lower) {
            return 0.0;
        }
        if (x > this.upper) {
            return 1.0;
        }
        return ((double)(x - this.lower) + 1.0) / (this.upperMinusLower + 1.0);
    }

    @Override
    public double getNumericalMean() {
        return 0.5 * this.upperPlusLower;
    }

    @Override
    public double getNumericalVariance() {
        double n = this.upperMinusLower + 1.0;
        return (n * n - 1.0) / 12.0;
    }

    @Override
    public int getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public IntegerDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new IntegerDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new DiscreteUniformSampler(rng, UniformIntegerDistribution.this.lower, UniformIntegerDistribution.this.upper);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

