/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.threed;

import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.Vector;
import org.apache.commons.math4.geometry.euclidean.oned.Cartesian1D;
import org.apache.commons.math4.geometry.euclidean.threed.Cartesian3D;
import org.apache.commons.math4.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math4.geometry.euclidean.threed.Line;
import org.apache.commons.math4.geometry.euclidean.threed.PolyhedronsSet;
import org.apache.commons.math4.geometry.euclidean.threed.Rotation;
import org.apache.commons.math4.geometry.euclidean.threed.SubPlane;
import org.apache.commons.math4.geometry.euclidean.twod.Cartesian2D;
import org.apache.commons.math4.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math4.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math4.geometry.partitioning.Embedding;
import org.apache.commons.math4.geometry.partitioning.Hyperplane;
import org.apache.commons.math4.util.FastMath;

public class Plane
implements Hyperplane<Euclidean3D>,
Embedding<Euclidean3D, Euclidean2D> {
    private double originOffset;
    private Cartesian3D origin;
    private Cartesian3D u;
    private Cartesian3D v;
    private Cartesian3D w;
    private final double tolerance;

    public Plane(Cartesian3D normal, double tolerance) throws MathArithmeticException {
        this.setNormal(normal);
        this.tolerance = tolerance;
        this.originOffset = 0.0;
        this.setFrame();
    }

    public Plane(Cartesian3D p, Cartesian3D normal, double tolerance) throws MathArithmeticException {
        this.setNormal(normal);
        this.tolerance = tolerance;
        this.originOffset = -p.dotProduct(this.w);
        this.setFrame();
    }

    public Plane(Cartesian3D p1, Cartesian3D p2, Cartesian3D p3, double tolerance) throws MathArithmeticException {
        this(p1, ((Cartesian3D)p2.subtract((Vector)p1)).crossProduct(p3.subtract((Vector)p1)), tolerance);
    }

    public Plane(Plane plane) {
        this.originOffset = plane.originOffset;
        this.origin = plane.origin;
        this.u = plane.u;
        this.v = plane.v;
        this.w = plane.w;
        this.tolerance = plane.tolerance;
    }

    public Plane copySelf() {
        return new Plane(this);
    }

    public void reset(Cartesian3D p, Cartesian3D normal) throws MathArithmeticException {
        this.setNormal(normal);
        this.originOffset = -p.dotProduct(this.w);
        this.setFrame();
    }

    public void reset(Plane original) {
        this.originOffset = original.originOffset;
        this.origin = original.origin;
        this.u = original.u;
        this.v = original.v;
        this.w = original.w;
    }

    private void setNormal(Cartesian3D normal) throws MathArithmeticException {
        double norm = normal.getNorm();
        if (norm < 1.0E-10) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.w = new Cartesian3D(1.0 / norm, normal);
    }

    private void setFrame() {
        this.origin = new Cartesian3D(-this.originOffset, this.w);
        this.u = this.w.orthogonal();
        this.v = Cartesian3D.crossProduct(this.w, this.u);
    }

    public Cartesian3D getOrigin() {
        return this.origin;
    }

    public Cartesian3D getNormal() {
        return this.w;
    }

    public Cartesian3D getU() {
        return this.u;
    }

    public Cartesian3D getV() {
        return this.v;
    }

    @Override
    public Point<Euclidean3D> project(Point<Euclidean3D> point) {
        return this.toSpace((Cartesian2D)this.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public void revertSelf() {
        Cartesian3D tmp = this.u;
        this.u = this.v;
        this.v = tmp;
        this.w = this.w.negate();
        this.originOffset = -this.originOffset;
    }

    public Cartesian2D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Cartesian3D)vector);
    }

    public Cartesian3D toSpace(Vector<Euclidean2D> vector) {
        return this.toSpace((Cartesian2D)vector);
    }

    public Cartesian2D toSubSpace(Point<Euclidean3D> point) {
        return this.toSubSpace((Cartesian3D)point);
    }

    public Cartesian3D toSpace(Point<Euclidean2D> point) {
        return this.toSpace((Cartesian2D)point);
    }

    public Cartesian2D toSubSpace(Cartesian3D point) {
        return new Cartesian2D(point.dotProduct(this.u), point.dotProduct(this.v));
    }

    public Cartesian3D toSpace(Cartesian2D point) {
        return new Cartesian3D(point.getX(), this.u, point.getY(), this.v, -this.originOffset, this.w);
    }

    public Cartesian3D getPointAt(Cartesian2D inPlane, double offset) {
        return new Cartesian3D(inPlane.getX(), this.u, inPlane.getY(), this.v, offset - this.originOffset, this.w);
    }

    public boolean isSimilarTo(Plane plane) {
        double angle = Cartesian3D.angle(this.w, plane.w);
        return angle < 1.0E-10 && FastMath.abs(this.originOffset - plane.originOffset) < this.tolerance || angle > 3.141592653489793 && FastMath.abs(this.originOffset + plane.originOffset) < this.tolerance;
    }

    public Plane rotate(Cartesian3D center, Rotation rotation) {
        Vector delta = this.origin.subtract((Vector)center);
        Plane plane = new Plane((Cartesian3D)center.add((Vector)rotation.applyTo((Cartesian3D)delta)), rotation.applyTo(this.w), this.tolerance);
        plane.u = rotation.applyTo(this.u);
        plane.v = rotation.applyTo(this.v);
        return plane;
    }

    public Plane translate(Cartesian3D translation) {
        Plane plane = new Plane((Cartesian3D)this.origin.add((Vector)translation), this.w, this.tolerance);
        plane.u = this.u;
        plane.v = this.v;
        return plane;
    }

    public Cartesian3D intersection(Line line) {
        Cartesian3D direction = line.getDirection();
        double dot = this.w.dotProduct(direction);
        if (FastMath.abs(dot) < 1.0E-10) {
            return null;
        }
        Cartesian3D point = line.toSpace(Cartesian1D.ZERO);
        double k = -(this.originOffset + this.w.dotProduct(point)) / dot;
        return new Cartesian3D(1.0, point, k, direction);
    }

    public Line intersection(Plane other) {
        Cartesian3D direction = Cartesian3D.crossProduct(this.w, other.w);
        if (direction.getNorm() < this.tolerance) {
            return null;
        }
        Cartesian3D point = Plane.intersection(this, other, new Plane(direction, this.tolerance));
        return new Line(point, (Cartesian3D)point.add((Vector)direction), this.tolerance);
    }

    public static Cartesian3D intersection(Plane plane1, Plane plane2, Plane plane3) {
        double a1 = plane1.w.getX();
        double b1 = plane1.w.getY();
        double c1 = plane1.w.getZ();
        double d1 = plane1.originOffset;
        double a2 = plane2.w.getX();
        double b2 = plane2.w.getY();
        double c2 = plane2.w.getZ();
        double d2 = plane2.originOffset;
        double a3 = plane3.w.getX();
        double b3 = plane3.w.getY();
        double c3 = plane3.w.getZ();
        double d3 = plane3.originOffset;
        double a23 = b2 * c3 - b3 * c2;
        double b23 = c2 * a3 - c3 * a2;
        double c23 = a2 * b3 - a3 * b2;
        double determinant = a1 * a23 + b1 * b23 + c1 * c23;
        if (FastMath.abs(determinant) < 1.0E-10) {
            return null;
        }
        double r = 1.0 / determinant;
        return new Cartesian3D((-a23 * d1 - (c1 * b3 - c3 * b1) * d2 - (c2 * b1 - c1 * b2) * d3) * r, (-b23 * d1 - (c3 * a1 - c1 * a3) * d2 - (c1 * a2 - c2 * a1) * d3) * r, (-c23 * d1 - (b1 * a3 - b3 * a1) * d2 - (b2 * a1 - b1 * a2) * d3) * r);
    }

    public SubPlane wholeHyperplane() {
        return new SubPlane(this, new PolygonsSet(this.tolerance));
    }

    public PolyhedronsSet wholeSpace() {
        return new PolyhedronsSet(this.tolerance);
    }

    public boolean contains(Cartesian3D p) {
        return FastMath.abs(this.getOffset(p)) < this.tolerance;
    }

    public double getOffset(Plane plane) {
        return this.originOffset + (this.sameOrientationAs(plane) ? -plane.originOffset : plane.originOffset);
    }

    @Override
    public double getOffset(Point<Euclidean3D> point) {
        return ((Cartesian3D)point).dotProduct(this.w) + this.originOffset;
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean3D> other) {
        return ((Plane)other).w.dotProduct(this.w) > 0.0;
    }
}

