/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ode;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math4.ode.ParameterizedODE;
import org.apache.commons.math4.ode.UnknownParameterException;

class ParameterizedWrapper
implements ParameterizedODE {
    private final FirstOrderDifferentialEquations fode;

    ParameterizedWrapper(FirstOrderDifferentialEquations ode) {
        this.fode = ode;
    }

    public int getDimension() {
        return this.fode.getDimension();
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) throws MaxCountExceededException, DimensionMismatchException {
        this.fode.computeDerivatives(t, y, yDot);
    }

    @Override
    public Collection<String> getParametersNames() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isSupported(String name) {
        return false;
    }

    @Override
    public double getParameter(String name) throws UnknownParameterException {
        if (!this.isSupported(name)) {
            throw new UnknownParameterException(name);
        }
        return Double.NaN;
    }

    @Override
    public void setParameter(String name, double value) {
    }
}

