/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.stat.descriptive;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math4.util.MathArrays;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    @Override
    public double evaluate(double[] values) throws MathIllegalArgumentException {
        MathArrays.verifyValues(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3) throws MathIllegalArgumentException;

    @Override
    public abstract UnivariateStatistic copy();

    public void setData(double[] values) {
        this.storedData = values == null ? null : (double[])values.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), values.length, true);
        }
        this.storedData = new double[length];
        System.arraycopy(values, begin, this.storedData, 0, length);
    }

    public double evaluate() throws MathIllegalArgumentException {
        return this.evaluate(this.storedData);
    }
}

