/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.stat.descriptive.moment.ThirdMoment;
import org.apache.commons.math4.util.MathUtils;

class FourthMoment
extends ThirdMoment
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private double m4;

    FourthMoment() {
        this.m4 = Double.NaN;
    }

    FourthMoment(FourthMoment original) throws NullArgumentException {
        FourthMoment.copy(original, this);
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m4 = 0.0;
            this.m3 = 0.0;
            this.m2 = 0.0;
            this.m1 = 0.0;
        }
        double prevM3 = this.m3;
        double prevM2 = this.m2;
        super.increment(d);
        double n0 = this.n;
        this.m4 = this.m4 - 4.0 * this.nDev * prevM3 + 6.0 * this.nDevSq * prevM2 + (n0 * n0 - 3.0 * (n0 - 1.0)) * (this.nDevSq * this.nDevSq * (n0 - 1.0) * n0);
    }

    @Override
    public double getResult() {
        return this.m4;
    }

    @Override
    public void clear() {
        super.clear();
        this.m4 = Double.NaN;
    }

    @Override
    public FourthMoment copy() {
        FourthMoment result = new FourthMoment();
        FourthMoment.copy(this, result);
        return result;
    }

    public static void copy(FourthMoment source, FourthMoment dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        ThirdMoment.copy(source, dest);
        dest.m4 = source.m4;
    }
}

