/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.angle;

public class PlaneAngle {
    public static final PlaneAngle ZERO = new PlaneAngle(0.0);
    public static final PlaneAngle PI = new PlaneAngle(0.5);
    private static final double HALF_TURN = 0.5;
    private static final double TO_RADIANS = Math.PI * 2;
    private static final double FROM_RADIANS = 0.15915494309189535;
    private static final double TO_DEGREES = 360.0;
    private static final double FROM_DEGREES = 0.002777777777777778;
    private final double value;

    private PlaneAngle(double value) {
        this.value = value;
    }

    public static PlaneAngle ofTurns(double angle) {
        return new PlaneAngle(angle);
    }

    public static PlaneAngle ofRadians(double angle) {
        return new PlaneAngle(angle * 0.15915494309189535);
    }

    public static PlaneAngle ofDegrees(double angle) {
        return new PlaneAngle(angle * 0.002777777777777778);
    }

    public double toTurns() {
        return this.value;
    }

    public double toRadians() {
        return this.value * (Math.PI * 2);
    }

    public double toDegrees() {
        return this.value * 360.0;
    }

    public PlaneAngle normalize(PlaneAngle center) {
        return new PlaneAngle(this.value - Math.floor(this.value + 0.5 - center.value));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PlaneAngle) {
            return new Double(this.value).equals(new Double(((PlaneAngle)other).value));
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }
}

