/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class MarsagliaNormalizedGaussianSampler
extends SamplerBase
implements NormalizedGaussianSampler {
    private double nextGaussian = Double.NaN;

    public MarsagliaNormalizedGaussianSampler(UniformRandomProvider rng) {
        super(rng);
    }

    @Override
    public double sample() {
        if (Double.isNaN(this.nextGaussian)) {
            double y;
            double x;
            double r2;
            while ((r2 = (x = 2.0 * this.nextDouble() - 1.0) * x + (y = 2.0 * this.nextDouble() - 1.0) * y) > 1.0 || r2 == 0.0) {
            }
            double alpha = Math.sqrt(-2.0 * Math.log(r2) / r2);
            this.nextGaussian = alpha * y;
            return alpha * x;
        }
        double r = this.nextGaussian;
        this.nextGaussian = Double.NaN;
        return r;
    }

    @Override
    public String toString() {
        return "Box-Muller (with rejection) normalized Gaussian deviate [" + super.toString() + "]";
    }
}

