/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class PoissonSampler
extends SamplerBase
implements DiscreteSampler {
    private static final double PIVOT = 40.0;
    private final double mean;
    private final ContinuousSampler exponential;
    private final NormalizedGaussianSampler gaussian;
    private final InternalUtils.FactorialLog factorialLog;

    public PoissonSampler(UniformRandomProvider rng, double mean) {
        super(rng);
        if (mean <= 0.0) {
            throw new IllegalArgumentException(mean + " <= " + 0);
        }
        this.mean = mean;
        this.gaussian = new MarsagliaNormalizedGaussianSampler(rng);
        this.exponential = new AhrensDieterExponentialSampler(rng, 1.0);
        this.factorialLog = mean < 40.0 ? null : InternalUtils.FactorialLog.create().withCache((int)Math.min(mean, 80.0));
    }

    @Override
    public int sample() {
        return (int)Math.min(this.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    @Override
    public String toString() {
        return "Poisson deviate [" + super.toString() + "]";
    }

    private long nextPoisson(double meanPoisson) {
        double y;
        long y2;
        block8: {
            if (meanPoisson < 40.0) {
                double p = Math.exp(-meanPoisson);
                long n = 0L;
                double r = 1.0;
                while ((double)n < 1000.0 * meanPoisson && (r *= this.nextDouble()) >= p) {
                    ++n;
                }
                return n;
            }
            double lambda = Math.floor(meanPoisson);
            double lambdaFractional = meanPoisson - lambda;
            double logLambda = Math.log(lambda);
            double logLambdaFactorial = this.factorialLog((int)lambda);
            y2 = lambdaFractional < Double.MIN_VALUE ? 0L : this.nextPoisson(lambdaFractional);
            double delta = Math.sqrt(lambda * Math.log(32.0 * lambda / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda + delta;
            double a1 = Math.sqrt(Math.PI * twolpd) * Math.exp(1.0 / (8.0 * lambda));
            double a2 = twolpd / delta * Math.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda);
            while (true) {
                double v;
                double x;
                double u;
                if ((u = this.nextDouble()) <= p1) {
                    double n = this.gaussian.sample();
                    x = n * Math.sqrt(lambda + halfDelta) - 0.5;
                    if (x > delta || x < -lambda) continue;
                    y = x < 0.0 ? Math.floor(x) : Math.ceil(x);
                    double e = this.exponential.sample();
                    v = -e - 0.5 * n * n + c1;
                } else {
                    if (u > p1 + p2) {
                        y = lambda;
                        break block8;
                    }
                    x = delta + twolpd / delta * this.exponential.sample();
                    y = Math.ceil(x);
                    v = -this.exponential.sample() - delta * (x + 1.0) / twolpd;
                }
                boolean a = x < 0.0;
                double t = y * (y + 1.0) / (2.0 * lambda);
                if (v < -t && !a) {
                    y = lambda + y;
                    break block8;
                }
                double qr = t * ((2.0 * y + 1.0) / (6.0 * lambda) - 1.0);
                double qa = qr - t * t / (3.0 * (lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = lambda + y;
                    break block8;
                }
                if (!(v > qr) && v < y * logLambda - this.factorialLog((int)(y + lambda)) + logLambdaFactorial) break;
            }
            y = lambda + y;
        }
        return y2 + (long)y;
    }

    private double factorialLog(int n) {
        return this.factorialLog.value(n);
    }
}

