/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.internal.ProviderBuilder;
import org.apache.commons.rng.simple.internal.SeedFactory;

public enum RandomSource {
    JDK(ProviderBuilder.RandomSourceInternal.JDK),
    WELL_512_A(ProviderBuilder.RandomSourceInternal.WELL_512_A),
    WELL_1024_A(ProviderBuilder.RandomSourceInternal.WELL_1024_A),
    WELL_19937_A(ProviderBuilder.RandomSourceInternal.WELL_19937_A),
    WELL_19937_C(ProviderBuilder.RandomSourceInternal.WELL_19937_C),
    WELL_44497_A(ProviderBuilder.RandomSourceInternal.WELL_44497_A),
    WELL_44497_B(ProviderBuilder.RandomSourceInternal.WELL_44497_B),
    MT(ProviderBuilder.RandomSourceInternal.MT),
    ISAAC(ProviderBuilder.RandomSourceInternal.ISAAC),
    SPLIT_MIX_64(ProviderBuilder.RandomSourceInternal.SPLIT_MIX_64),
    XOR_SHIFT_1024_S(ProviderBuilder.RandomSourceInternal.XOR_SHIFT_1024_S),
    TWO_CMRES(ProviderBuilder.RandomSourceInternal.TWO_CMRES),
    TWO_CMRES_SELECT(ProviderBuilder.RandomSourceInternal.TWO_CMRES_SELECT),
    MT_64(ProviderBuilder.RandomSourceInternal.MT_64),
    MWC_256(ProviderBuilder.RandomSourceInternal.MWC_256),
    KISS(ProviderBuilder.RandomSourceInternal.KISS);

    private final ProviderBuilder.RandomSourceInternal internalIdentifier;

    private RandomSource(ProviderBuilder.RandomSourceInternal id) {
        this.internalIdentifier = id;
    }

    ProviderBuilder.RandomSourceInternal getInternalIdentifier() {
        return this.internalIdentifier;
    }

    public boolean isNativeSeed(Object seed) {
        return this.internalIdentifier.isNativeSeed(seed);
    }

    public static RestorableUniformRandomProvider create(RandomSource source) {
        return RandomSource.create(source, null, new Object[0]);
    }

    public static RestorableUniformRandomProvider create(RandomSource source, Object seed, Object ... data) {
        return ProviderBuilder.create(source.getInternalIdentifier(), seed, data);
    }

    public static int createInt() {
        return SeedFactory.createInt();
    }

    public static long createLong() {
        return SeedFactory.createLong();
    }

    public static int[] createIntArray(int n) {
        return SeedFactory.createIntArray(n);
    }

    public static long[] createLongArray(int n) {
        return SeedFactory.createLongArray(n);
    }

    public static UniformRandomProvider unrestorable(final UniformRandomProvider delegate) {
        return new UniformRandomProvider(){

            @Override
            public void nextBytes(byte[] bytes) {
                delegate.nextBytes(bytes);
            }

            @Override
            public void nextBytes(byte[] bytes, int start, int len) {
                delegate.nextBytes(bytes, start, len);
            }

            @Override
            public int nextInt() {
                return delegate.nextInt();
            }

            @Override
            public int nextInt(int n) {
                return delegate.nextInt(n);
            }

            @Override
            public long nextLong() {
                return delegate.nextLong();
            }

            @Override
            public long nextLong(long n) {
                return delegate.nextLong(n);
            }

            @Override
            public boolean nextBoolean() {
                return delegate.nextBoolean();
            }

            @Override
            public float nextFloat() {
                return delegate.nextFloat();
            }

            @Override
            public double nextDouble() {
                return delegate.nextDouble();
            }

            public String toString() {
                return delegate.toString();
            }
        };
    }
}

