
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.LimitRangeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class LimitRangeHandler implements ResourceHandler<LimitRange, LimitRangeBuilder> {

  @Override
  public String getKind() {
    return LimitRange.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public LimitRange create(OkHttpClient client, Config config, String namespace, LimitRange item, boolean dryRun) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public LimitRange replace(OkHttpClient client, Config config, String namespace, LimitRange item, boolean dryRun) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public LimitRange reload(OkHttpClient client, Config config, String namespace, LimitRange item) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public LimitRangeBuilder edit(LimitRange item) {
    return new LimitRangeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, LimitRange item, boolean dryRun) {
    return new LimitRangeOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, LimitRange item, Watcher<LimitRange> watcher) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, LimitRange item, String resourceVersion, Watcher<LimitRange> watcher) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, LimitRange item, ListOptions options, Watcher<LimitRange> watcher) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public LimitRange waitUntilReady(OkHttpClient client, Config config, String namespace, LimitRange item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public LimitRange waitUntilCondition(OkHttpClient client, Config config, String namespace, LimitRange item, Predicate<LimitRange> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
