package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerStateRunningFluentImpl<A extends ContainerStateRunningFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerStateRunningFluent<A>{

    private TimeBuilder startedAt;

    public ContainerStateRunningFluentImpl(){
    }
    public ContainerStateRunningFluentImpl(ContainerStateRunning instance){
            this.withStartedAt(instance.getStartedAt()); 
    }

    
/**
 * This method has been deprecated, please use method buildStartedAt instead.
 */
@Deprecated public Time getStartedAt(){
            return this.startedAt!=null?this.startedAt.build():null;
    }

    public Time buildStartedAt(){
            return this.startedAt!=null?this.startedAt.build():null;
    }

    public A withStartedAt(Time startedAt){
            _visitables.remove(this.startedAt);
            if (startedAt!=null){ this.startedAt= new TimeBuilder(startedAt); _visitables.add(this.startedAt);} return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.startedAt!=null;
    }

    public ContainerStateRunningFluent.StartedAtNested<A> withNewStartedAt(){
            return new StartedAtNestedImpl();
    }

    public ContainerStateRunningFluent.StartedAtNested<A> withNewStartedAtLike(Time item){
            return new StartedAtNestedImpl(item);
    }

    public ContainerStateRunningFluent.StartedAtNested<A> editStartedAt(){
            return withNewStartedAtLike(getStartedAt());
    }

    public ContainerStateRunningFluent.StartedAtNested<A> editOrNewStartedAt(){
            return withNewStartedAtLike(getStartedAt() != null ? getStartedAt(): new TimeBuilder().build());
    }

    public ContainerStateRunningFluent.StartedAtNested<A> editOrNewStartedAtLike(Time item){
            return withNewStartedAtLike(getStartedAt() != null ? getStartedAt(): item);
    }

    public A withNewStartedAt(String time){
            return (A)withStartedAt(new Time(time));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerStateRunningFluentImpl that = (ContainerStateRunningFluentImpl) o;
            if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
            return true;
    }


    public class StartedAtNestedImpl<N> extends TimeFluentImpl<ContainerStateRunningFluent.StartedAtNested<N>> implements ContainerStateRunningFluent.StartedAtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            StartedAtNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            StartedAtNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) ContainerStateRunningFluentImpl.this.withStartedAt(builder.build());
    }
    public N endStartedAt(){
            return and();
    }

}


}
