package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface EventFluent<A extends EventFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public Integer getCount();
    public A withCount(Integer count);
    public Boolean hasCount();
    
/**
 * This method has been deprecated, please use method buildFirstTimestamp instead.
 */
@Deprecated public Time getFirstTimestamp();
    public Time buildFirstTimestamp();
    public A withFirstTimestamp(Time firstTimestamp);
    public Boolean hasFirstTimestamp();
    public EventFluent.FirstTimestampNested<A> withNewFirstTimestamp();
    public EventFluent.FirstTimestampNested<A> withNewFirstTimestampLike(Time item);
    public EventFluent.FirstTimestampNested<A> editFirstTimestamp();
    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestamp();
    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestampLike(Time item);
    public A withNewFirstTimestamp(String time);
    
/**
 * This method has been deprecated, please use method buildInvolvedObject instead.
 */
@Deprecated public ObjectReference getInvolvedObject();
    public ObjectReference buildInvolvedObject();
    public A withInvolvedObject(ObjectReference involvedObject);
    public Boolean hasInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item);
    public EventFluent.InvolvedObjectNested<A> editInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildLastTimestamp instead.
 */
@Deprecated public Time getLastTimestamp();
    public Time buildLastTimestamp();
    public A withLastTimestamp(Time lastTimestamp);
    public Boolean hasLastTimestamp();
    public EventFluent.LastTimestampNested<A> withNewLastTimestamp();
    public EventFluent.LastTimestampNested<A> withNewLastTimestampLike(Time item);
    public EventFluent.LastTimestampNested<A> editLastTimestamp();
    public EventFluent.LastTimestampNested<A> editOrNewLastTimestamp();
    public EventFluent.LastTimestampNested<A> editOrNewLastTimestampLike(Time item);
    public A withNewLastTimestamp(String time);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public EventFluent.MetadataNested<A> withNewMetadata();
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EventFluent.MetadataNested<A> editMetadata();
    public EventFluent.MetadataNested<A> editOrNewMetadata();
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    
/**
 * This method has been deprecated, please use method buildSource instead.
 */
@Deprecated public EventSource getSource();
    public EventSource buildSource();
    public A withSource(EventSource source);
    public Boolean hasSource();
    public EventFluent.SourceNested<A> withNewSource();
    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item);
    public EventFluent.SourceNested<A> editSource();
    public EventFluent.SourceNested<A> editOrNewSource();
    public EventFluent.SourceNested<A> editOrNewSourceLike(EventSource item);
    public A withNewSource(String component,String host);
    public String getType();
    public A withType(String type);
    public Boolean hasType();

    public interface FirstTimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<EventFluent.FirstTimestampNested<N>>{

        
    public N and();    public N endFirstTimestamp();
}
    public interface InvolvedObjectNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<EventFluent.InvolvedObjectNested<N>>{

        
    public N and();    public N endInvolvedObject();
}
    public interface LastTimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<EventFluent.LastTimestampNested<N>>{

        
    public N and();    public N endLastTimestamp();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<EventFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SourceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventSourceFluent<EventFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}


}
