package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface JobStatusFluent<A extends JobStatusFluent<A>> extends Fluent<A>{


    public Integer getActive();
    public A withActive(Integer active);
    public Boolean hasActive();
    
/**
 * This method has been deprecated, please use method buildCompletionTime instead.
 */
@Deprecated public Time getCompletionTime();
    public Time buildCompletionTime();
    public A withCompletionTime(Time completionTime);
    public Boolean hasCompletionTime();
    public JobStatusFluent.CompletionTimeNested<A> withNewCompletionTime();
    public JobStatusFluent.CompletionTimeNested<A> withNewCompletionTimeLike(Time item);
    public JobStatusFluent.CompletionTimeNested<A> editCompletionTime();
    public JobStatusFluent.CompletionTimeNested<A> editOrNewCompletionTime();
    public JobStatusFluent.CompletionTimeNested<A> editOrNewCompletionTimeLike(Time item);
    public A withNewCompletionTime(String time);
    public A addToConditions(int index,JobCondition item);
    public A setToConditions(int index,JobCondition item);
    public A addToConditions(JobCondition... items);
    public A addAllToConditions(Collection<JobCondition> items);
    public A removeFromConditions(JobCondition... items);
    public A removeAllFromConditions(Collection<JobCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 */
@Deprecated public List<JobCondition> getConditions();
    public List<JobCondition> buildConditions();
    public JobCondition buildCondition(int index);
    public JobCondition buildFirstCondition();
    public JobCondition buildLastCondition();
    public JobCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<JobConditionBuilder> predicate);
    public A withConditions(List<JobCondition> conditions);
    public A withConditions(JobCondition... conditions);
    public Boolean hasConditions();
    public JobStatusFluent.ConditionsNested<A> addNewCondition();
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item);
    public JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index,JobCondition item);
    public JobStatusFluent.ConditionsNested<A> editCondition(int index);
    public JobStatusFluent.ConditionsNested<A> editFirstCondition();
    public JobStatusFluent.ConditionsNested<A> editLastCondition();
    public JobStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<JobConditionBuilder> predicate);
    public Integer getFailed();
    public A withFailed(Integer failed);
    public Boolean hasFailed();
    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 */
@Deprecated public Time getStartTime();
    public Time buildStartTime();
    public A withStartTime(Time startTime);
    public Boolean hasStartTime();
    public JobStatusFluent.StartTimeNested<A> withNewStartTime();
    public JobStatusFluent.StartTimeNested<A> withNewStartTimeLike(Time item);
    public JobStatusFluent.StartTimeNested<A> editStartTime();
    public JobStatusFluent.StartTimeNested<A> editOrNewStartTime();
    public JobStatusFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item);
    public A withNewStartTime(String time);
    public Integer getSucceeded();
    public A withSucceeded(Integer succeeded);
    public Boolean hasSucceeded();

    public interface CompletionTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<JobStatusFluent.CompletionTimeNested<N>>{

        
    public N and();    public N endCompletionTime();
}
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JobConditionFluent<JobStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface StartTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<JobStatusFluent.StartTimeNested<N>>{

        
    public N and();    public N endStartTime();
}


}
