package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NodeConditionFluentImpl<A extends NodeConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeConditionFluent<A>{

    private TimeBuilder lastHeartbeatTime;
    private TimeBuilder lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public NodeConditionFluentImpl(){
    }
    public NodeConditionFluentImpl(NodeCondition instance){
            this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildLastHeartbeatTime instead.
 */
@Deprecated public Time getLastHeartbeatTime(){
            return this.lastHeartbeatTime!=null?this.lastHeartbeatTime.build():null;
    }

    public Time buildLastHeartbeatTime(){
            return this.lastHeartbeatTime!=null?this.lastHeartbeatTime.build():null;
    }

    public A withLastHeartbeatTime(Time lastHeartbeatTime){
            _visitables.remove(this.lastHeartbeatTime);
            if (lastHeartbeatTime!=null){ this.lastHeartbeatTime= new TimeBuilder(lastHeartbeatTime); _visitables.add(this.lastHeartbeatTime);} return (A) this;
    }

    public Boolean hasLastHeartbeatTime(){
            return this.lastHeartbeatTime!=null;
    }

    public NodeConditionFluent.LastHeartbeatTimeNested<A> withNewLastHeartbeatTime(){
            return new LastHeartbeatTimeNestedImpl();
    }

    public NodeConditionFluent.LastHeartbeatTimeNested<A> withNewLastHeartbeatTimeLike(Time item){
            return new LastHeartbeatTimeNestedImpl(item);
    }

    public NodeConditionFluent.LastHeartbeatTimeNested<A> editLastHeartbeatTime(){
            return withNewLastHeartbeatTimeLike(getLastHeartbeatTime());
    }

    public NodeConditionFluent.LastHeartbeatTimeNested<A> editOrNewLastHeartbeatTime(){
            return withNewLastHeartbeatTimeLike(getLastHeartbeatTime() != null ? getLastHeartbeatTime(): new TimeBuilder().build());
    }

    public NodeConditionFluent.LastHeartbeatTimeNested<A> editOrNewLastHeartbeatTimeLike(Time item){
            return withNewLastHeartbeatTimeLike(getLastHeartbeatTime() != null ? getLastHeartbeatTime(): item);
    }

    public A withNewLastHeartbeatTime(String time){
            return (A)withLastHeartbeatTime(new Time(time));
    }

    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 */
@Deprecated public Time getLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public Time buildLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public A withLastTransitionTime(Time lastTransitionTime){
            _visitables.remove(this.lastTransitionTime);
            if (lastTransitionTime!=null){ this.lastTransitionTime= new TimeBuilder(lastTransitionTime); _visitables.add(this.lastTransitionTime);} return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime!=null;
    }

    public NodeConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime(){
            return new LastTransitionTimeNestedImpl();
    }

    public NodeConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item){
            return new LastTransitionTimeNestedImpl(item);
    }

    public NodeConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime());
    }

    public NodeConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): new TimeBuilder().build());
    }

    public NodeConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): item);
    }

    public A withNewLastTransitionTime(String time){
            return (A)withLastTransitionTime(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeConditionFluentImpl that = (NodeConditionFluentImpl) o;
            if (lastHeartbeatTime != null ? !lastHeartbeatTime.equals(that.lastHeartbeatTime) :that.lastHeartbeatTime != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class LastHeartbeatTimeNestedImpl<N> extends TimeFluentImpl<NodeConditionFluent.LastHeartbeatTimeNested<N>> implements NodeConditionFluent.LastHeartbeatTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastHeartbeatTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastHeartbeatTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) NodeConditionFluentImpl.this.withLastHeartbeatTime(builder.build());
    }
    public N endLastHeartbeatTime(){
            return and();
    }

}
    public class LastTransitionTimeNestedImpl<N> extends TimeFluentImpl<NodeConditionFluent.LastTransitionTimeNested<N>> implements NodeConditionFluent.LastTransitionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastTransitionTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastTransitionTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) NodeConditionFluentImpl.this.withLastTransitionTime(builder.build());
    }
    public N endLastTransitionTime(){
            return and();
    }

}


}
