package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class ClusterPolicyFluentImpl<A extends ClusterPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterPolicyFluent<A>{

    private String apiVersion;
    private String kind;
    private TimeBuilder lastModified;
    private ObjectMetaBuilder metadata;
    private List<NamedClusterRoleBuilder> roles =  new ArrayList<NamedClusterRoleBuilder>();

    public ClusterPolicyFluentImpl(){
    }
    public ClusterPolicyFluentImpl(ClusterPolicy instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion!=null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind!=null;
    }

    
/**
 * This method has been deprecated, please use method buildLastModified instead.
 */
@Deprecated public Time getLastModified(){
            return this.lastModified!=null?this.lastModified.build():null;
    }

    public Time buildLastModified(){
            return this.lastModified!=null?this.lastModified.build():null;
    }

    public A withLastModified(Time lastModified){
            _visitables.remove(this.lastModified);
            if (lastModified!=null){ this.lastModified= new TimeBuilder(lastModified); _visitables.add(this.lastModified);} return (A) this;
    }

    public Boolean hasLastModified(){
            return this.lastModified!=null;
    }

    public ClusterPolicyFluent.LastModifiedNested<A> withNewLastModified(){
            return new LastModifiedNestedImpl();
    }

    public ClusterPolicyFluent.LastModifiedNested<A> withNewLastModifiedLike(Time item){
            return new LastModifiedNestedImpl(item);
    }

    public ClusterPolicyFluent.LastModifiedNested<A> editLastModified(){
            return withNewLastModifiedLike(getLastModified());
    }

    public ClusterPolicyFluent.LastModifiedNested<A> editOrNewLastModified(){
            return withNewLastModifiedLike(getLastModified() != null ? getLastModified(): new TimeBuilder().build());
    }

    public ClusterPolicyFluent.LastModifiedNested<A> editOrNewLastModifiedLike(Time item){
            return withNewLastModifiedLike(getLastModified() != null ? getLastModified(): item);
    }

    public A withNewLastModified(String time){
            return (A)withLastModified(new Time(time));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata!=null;
    }

    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ClusterPolicyFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRoles(int index,NamedClusterRole item){
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.roles.add(index >= 0 ? index : roles.size(), builder); return (A)this;
    }

    public A setToRoles(int index,NamedClusterRole item){
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= roles.size()) { roles.add(builder); } else { roles.set(index, builder);}
             return (A)this;
    }

    public A addToRoles(NamedClusterRole... items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }

    public A addAllToRoles(Collection<NamedClusterRole> items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }

    public A removeFromRoles(NamedClusterRole... items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.remove(builder);this.roles.remove(builder);} return (A)this;
    }

    public A removeAllFromRoles(Collection<NamedClusterRole> items){
            for (NamedClusterRole item : items) {NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);_visitables.remove(builder);this.roles.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoles instead.
 */
@Deprecated public List<NamedClusterRole> getRoles(){
            return build(roles);
    }

    public List<NamedClusterRole> buildRoles(){
            return build(roles);
    }

    public NamedClusterRole buildRole(int index){
            return this.roles.get(index).build();
    }

    public NamedClusterRole buildFirstRole(){
            return this.roles.get(0).build();
    }

    public NamedClusterRole buildLastRole(){
            return this.roles.get(roles.size() - 1).build();
    }

    public NamedClusterRole buildMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBuilder> predicate){
            for (NamedClusterRoleBuilder item: roles) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRoles(List<NamedClusterRole> roles){
            _visitables.removeAll(this.roles);
            this.roles.clear();
            if (roles != null) {for (NamedClusterRole item : roles){this.addToRoles(item);}} return (A) this;
    }

    public A withRoles(NamedClusterRole... roles){
            this.roles.clear(); if (roles != null) {for (NamedClusterRole item :roles){ this.addToRoles(item);}} return (A) this;
    }

    public Boolean hasRoles(){
            return roles!= null && !roles.isEmpty();
    }

    public ClusterPolicyFluent.RolesNested<A> addNewRole(){
            return new RolesNestedImpl();
    }

    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item){
            return new RolesNestedImpl(-1, item);
    }

    public ClusterPolicyFluent.RolesNested<A> setNewRoleLike(int index,NamedClusterRole item){
            return new RolesNestedImpl(index, item);
    }

    public ClusterPolicyFluent.RolesNested<A> editRole(int index){
            if (roles.size() <= index) throw new RuntimeException("Can't edit roles. Index exceeds size.");
            return setNewRoleLike(index, buildRole(index));
    }

    public ClusterPolicyFluent.RolesNested<A> editFirstRole(){
            if (roles.size() == 0) throw new RuntimeException("Can't edit first roles. The list is empty.");
            return setNewRoleLike(0, buildRole(0));
    }

    public ClusterPolicyFluent.RolesNested<A> editLastRole(){
            int index = roles.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last roles. The list is empty.");
            return setNewRoleLike(index, buildRole(index));
    }

    public ClusterPolicyFluent.RolesNested<A> editMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBuilder> predicate){
            int index = -1;
            for (int i=0;i<roles.size();i++) { 
            if (predicate.apply(roles.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching roles. No match found.");
            return setNewRoleLike(index, buildRole(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyFluentImpl that = (ClusterPolicyFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roles != null ? !roles.equals(that.roles) :that.roles != null) return false;
            return true;
    }


    public class LastModifiedNestedImpl<N> extends TimeFluentImpl<ClusterPolicyFluent.LastModifiedNested<N>> implements ClusterPolicyFluent.LastModifiedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastModifiedNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastModifiedNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) ClusterPolicyFluentImpl.this.withLastModified(builder.build());
    }
    public N endLastModified(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterPolicyFluent.MetadataNested<N>> implements ClusterPolicyFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ClusterPolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RolesNestedImpl<N> extends NamedClusterRoleFluentImpl<ClusterPolicyFluent.RolesNested<N>> implements ClusterPolicyFluent.RolesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamedClusterRoleBuilder builder;
        private final int index;
    
            RolesNestedImpl(int index,NamedClusterRole item){
                    this.index = index;
                    this.builder = new NamedClusterRoleBuilder(this, item);
            }
            RolesNestedImpl(){
                    this.index = -1;
                    this.builder = new NamedClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) ClusterPolicyFluentImpl.this.setToRoles(index, builder.build());
    }
    public N endRole(){
            return and();
    }

}


}
