package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class WebHookTriggerFluentImpl<A extends WebHookTriggerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WebHookTriggerFluent<A>{

    private Boolean allowEnv;
    private String secret;

    public WebHookTriggerFluentImpl(){
    }
    public WebHookTriggerFluentImpl(WebHookTrigger instance){
            this.withAllowEnv(instance.getAllowEnv()); 
            this.withSecret(instance.getSecret()); 
    }

    public Boolean isAllowEnv(){
            return this.allowEnv;
    }

    public A withAllowEnv(Boolean allowEnv){
            this.allowEnv=allowEnv; return (A) this;
    }

    public Boolean hasAllowEnv(){
            return this.allowEnv!=null;
    }

    public String getSecret(){
            return this.secret;
    }

    public A withSecret(String secret){
            this.secret=secret; return (A) this;
    }

    public Boolean hasSecret(){
            return this.secret!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WebHookTriggerFluentImpl that = (WebHookTriggerFluentImpl) o;
            if (allowEnv != null ? !allowEnv.equals(that.allowEnv) :that.allowEnv != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            return true;
    }




}
