package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;

public class EventFluentImpl<A extends EventFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventFluent<A>{

    private String apiVersion;
    private Integer count;
    private TimeBuilder firstTimestamp;
    private ObjectReferenceBuilder involvedObject;
    private String kind;
    private TimeBuilder lastTimestamp;
    private String message;
    private ObjectMetaBuilder metadata;
    private String reason;
    private EventSourceBuilder source;
    private String type;

    public EventFluentImpl(){
    }
    public EventFluentImpl(Event instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withCount(instance.getCount()); 
            this.withFirstTimestamp(instance.getFirstTimestamp()); 
            this.withInvolvedObject(instance.getInvolvedObject()); 
            this.withKind(instance.getKind()); 
            this.withLastTimestamp(instance.getLastTimestamp()); 
            this.withMessage(instance.getMessage()); 
            this.withMetadata(instance.getMetadata()); 
            this.withReason(instance.getReason()); 
            this.withSource(instance.getSource()); 
            this.withType(instance.getType()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion!=null;
    }

    public Integer getCount(){
            return this.count;
    }

    public A withCount(Integer count){
            this.count=count; return (A) this;
    }

    public Boolean hasCount(){
            return this.count!=null;
    }

    
/**
 * This method has been deprecated, please use method buildFirstTimestamp instead.
 */
@Deprecated public Time getFirstTimestamp(){
            return this.firstTimestamp!=null?this.firstTimestamp.build():null;
    }

    public Time buildFirstTimestamp(){
            return this.firstTimestamp!=null?this.firstTimestamp.build():null;
    }

    public A withFirstTimestamp(Time firstTimestamp){
            _visitables.remove(this.firstTimestamp);
            if (firstTimestamp!=null){ this.firstTimestamp= new TimeBuilder(firstTimestamp); _visitables.add(this.firstTimestamp);} return (A) this;
    }

    public Boolean hasFirstTimestamp(){
            return this.firstTimestamp!=null;
    }

    public EventFluent.FirstTimestampNested<A> withNewFirstTimestamp(){
            return new FirstTimestampNestedImpl();
    }

    public EventFluent.FirstTimestampNested<A> withNewFirstTimestampLike(Time item){
            return new FirstTimestampNestedImpl(item);
    }

    public EventFluent.FirstTimestampNested<A> editFirstTimestamp(){
            return withNewFirstTimestampLike(getFirstTimestamp());
    }

    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestamp(){
            return withNewFirstTimestampLike(getFirstTimestamp() != null ? getFirstTimestamp(): new TimeBuilder().build());
    }

    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestampLike(Time item){
            return withNewFirstTimestampLike(getFirstTimestamp() != null ? getFirstTimestamp(): item);
    }

    public A withNewFirstTimestamp(String time){
            return (A)withFirstTimestamp(new Time(time));
    }

    
/**
 * This method has been deprecated, please use method buildInvolvedObject instead.
 */
@Deprecated public ObjectReference getInvolvedObject(){
            return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public ObjectReference buildInvolvedObject(){
            return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public A withInvolvedObject(ObjectReference involvedObject){
            _visitables.remove(this.involvedObject);
            if (involvedObject!=null){ this.involvedObject= new ObjectReferenceBuilder(involvedObject); _visitables.add(this.involvedObject);} return (A) this;
    }

    public Boolean hasInvolvedObject(){
            return this.involvedObject!=null;
    }

    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject(){
            return new InvolvedObjectNestedImpl();
    }

    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item){
            return new InvolvedObjectNestedImpl(item);
    }

    public EventFluent.InvolvedObjectNested<A> editInvolvedObject(){
            return withNewInvolvedObjectLike(getInvolvedObject());
    }

    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject(){
            return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): new ObjectReferenceBuilder().build());
    }

    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item){
            return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind!=null;
    }

    
/**
 * This method has been deprecated, please use method buildLastTimestamp instead.
 */
@Deprecated public Time getLastTimestamp(){
            return this.lastTimestamp!=null?this.lastTimestamp.build():null;
    }

    public Time buildLastTimestamp(){
            return this.lastTimestamp!=null?this.lastTimestamp.build():null;
    }

    public A withLastTimestamp(Time lastTimestamp){
            _visitables.remove(this.lastTimestamp);
            if (lastTimestamp!=null){ this.lastTimestamp= new TimeBuilder(lastTimestamp); _visitables.add(this.lastTimestamp);} return (A) this;
    }

    public Boolean hasLastTimestamp(){
            return this.lastTimestamp!=null;
    }

    public EventFluent.LastTimestampNested<A> withNewLastTimestamp(){
            return new LastTimestampNestedImpl();
    }

    public EventFluent.LastTimestampNested<A> withNewLastTimestampLike(Time item){
            return new LastTimestampNestedImpl(item);
    }

    public EventFluent.LastTimestampNested<A> editLastTimestamp(){
            return withNewLastTimestampLike(getLastTimestamp());
    }

    public EventFluent.LastTimestampNested<A> editOrNewLastTimestamp(){
            return withNewLastTimestampLike(getLastTimestamp() != null ? getLastTimestamp(): new TimeBuilder().build());
    }

    public EventFluent.LastTimestampNested<A> editOrNewLastTimestampLike(Time item){
            return withNewLastTimestampLike(getLastTimestamp() != null ? getLastTimestamp(): item);
    }

    public A withNewLastTimestamp(String time){
            return (A)withLastTimestamp(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata!=null;
    }

    public EventFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public EventFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public EventFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 */
@Deprecated public EventSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public EventSource buildSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(EventSource source){
            _visitables.remove(this.source);
            if (source!=null){ this.source= new EventSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }

    public Boolean hasSource(){
            return this.source!=null;
    }

    public EventFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item){
            return new SourceNestedImpl(item);
    }

    public EventFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public EventFluent.SourceNested<A> editOrNewSource(){
            return withNewSourceLike(getSource() != null ? getSource(): new EventSourceBuilder().build());
    }

    public EventFluent.SourceNested<A> editOrNewSourceLike(EventSource item){
            return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public A withNewSource(String component,String host){
            return (A)withSource(new EventSource(component, host));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EventFluentImpl that = (EventFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (count != null ? !count.equals(that.count) :that.count != null) return false;
            if (firstTimestamp != null ? !firstTimestamp.equals(that.firstTimestamp) :that.firstTimestamp != null) return false;
            if (involvedObject != null ? !involvedObject.equals(that.involvedObject) :that.involvedObject != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastTimestamp != null ? !lastTimestamp.equals(that.lastTimestamp) :that.lastTimestamp != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class FirstTimestampNestedImpl<N> extends TimeFluentImpl<EventFluent.FirstTimestampNested<N>> implements EventFluent.FirstTimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            FirstTimestampNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            FirstTimestampNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) EventFluentImpl.this.withFirstTimestamp(builder.build());
    }
    public N endFirstTimestamp(){
            return and();
    }

}
    public class InvolvedObjectNestedImpl<N> extends ObjectReferenceFluentImpl<EventFluent.InvolvedObjectNested<N>> implements EventFluent.InvolvedObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            InvolvedObjectNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            InvolvedObjectNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) EventFluentImpl.this.withInvolvedObject(builder.build());
    }
    public N endInvolvedObject(){
            return and();
    }

}
    public class LastTimestampNestedImpl<N> extends TimeFluentImpl<EventFluent.LastTimestampNested<N>> implements EventFluent.LastTimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastTimestampNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastTimestampNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) EventFluentImpl.this.withLastTimestamp(builder.build());
    }
    public N endLastTimestamp(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>> implements EventFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) EventFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SourceNestedImpl<N> extends EventSourceFluentImpl<EventFluent.SourceNested<N>> implements EventFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventSourceBuilder builder;
    
            SourceNestedImpl(EventSource item){
                    this.builder = new EventSourceBuilder(this, item);
            }
            SourceNestedImpl(){
                    this.builder = new EventSourceBuilder(this);
            }
    
    public N and(){
            return (N) EventFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}


}
