package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SignatureConditionFluentImpl<A extends SignatureConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SignatureConditionFluent<A>{

    private TimeBuilder lastProbeTime;
    private TimeBuilder lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public SignatureConditionFluentImpl(){
    }
    public SignatureConditionFluentImpl(SignatureCondition instance){
            this.withLastProbeTime(instance.getLastProbeTime()); 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildLastProbeTime instead.
 */
@Deprecated public Time getLastProbeTime(){
            return this.lastProbeTime!=null?this.lastProbeTime.build():null;
    }

    public Time buildLastProbeTime(){
            return this.lastProbeTime!=null?this.lastProbeTime.build():null;
    }

    public A withLastProbeTime(Time lastProbeTime){
            _visitables.remove(this.lastProbeTime);
            if (lastProbeTime!=null){ this.lastProbeTime= new TimeBuilder(lastProbeTime); _visitables.add(this.lastProbeTime);} return (A) this;
    }

    public Boolean hasLastProbeTime(){
            return this.lastProbeTime!=null;
    }

    public SignatureConditionFluent.LastProbeTimeNested<A> withNewLastProbeTime(){
            return new LastProbeTimeNestedImpl();
    }

    public SignatureConditionFluent.LastProbeTimeNested<A> withNewLastProbeTimeLike(Time item){
            return new LastProbeTimeNestedImpl(item);
    }

    public SignatureConditionFluent.LastProbeTimeNested<A> editLastProbeTime(){
            return withNewLastProbeTimeLike(getLastProbeTime());
    }

    public SignatureConditionFluent.LastProbeTimeNested<A> editOrNewLastProbeTime(){
            return withNewLastProbeTimeLike(getLastProbeTime() != null ? getLastProbeTime(): new TimeBuilder().build());
    }

    public SignatureConditionFluent.LastProbeTimeNested<A> editOrNewLastProbeTimeLike(Time item){
            return withNewLastProbeTimeLike(getLastProbeTime() != null ? getLastProbeTime(): item);
    }

    public A withNewLastProbeTime(String time){
            return (A)withLastProbeTime(new Time(time));
    }

    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 */
@Deprecated public Time getLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public Time buildLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public A withLastTransitionTime(Time lastTransitionTime){
            _visitables.remove(this.lastTransitionTime);
            if (lastTransitionTime!=null){ this.lastTransitionTime= new TimeBuilder(lastTransitionTime); _visitables.add(this.lastTransitionTime);} return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime!=null;
    }

    public SignatureConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime(){
            return new LastTransitionTimeNestedImpl();
    }

    public SignatureConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item){
            return new LastTransitionTimeNestedImpl(item);
    }

    public SignatureConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime());
    }

    public SignatureConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): new TimeBuilder().build());
    }

    public SignatureConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): item);
    }

    public A withNewLastTransitionTime(String time){
            return (A)withLastTransitionTime(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignatureConditionFluentImpl that = (SignatureConditionFluentImpl) o;
            if (lastProbeTime != null ? !lastProbeTime.equals(that.lastProbeTime) :that.lastProbeTime != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class LastProbeTimeNestedImpl<N> extends TimeFluentImpl<SignatureConditionFluent.LastProbeTimeNested<N>> implements SignatureConditionFluent.LastProbeTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastProbeTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastProbeTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) SignatureConditionFluentImpl.this.withLastProbeTime(builder.build());
    }
    public N endLastProbeTime(){
            return and();
    }

}
    public class LastTransitionTimeNestedImpl<N> extends TimeFluentImpl<SignatureConditionFluent.LastTransitionTimeNested<N>> implements SignatureConditionFluent.LastTransitionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastTransitionTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastTransitionTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) SignatureConditionFluentImpl.this.withLastTransitionTime(builder.build());
    }
    public N endLastTransitionTime(){
            return and();
    }

}


}
