package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface PodTemplateFluent<A extends PodTemplateFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PodTemplateFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodTemplateFluent.MetadataNested<A> editMetadata();
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadata();
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public PodTemplateFluent.TemplateNested<A> withNewTemplate();
    public PodTemplateFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PodTemplateFluent.TemplateNested<A> editTemplate();
    public PodTemplateFluent.TemplateNested<A> editOrNewTemplate();
    public PodTemplateFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PodTemplateFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<PodTemplateFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
