package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface StorageClassFluent<A extends StorageClassFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public StorageClassFluent.MetadataNested<A> withNewMetadata();
    public StorageClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public StorageClassFluent.MetadataNested<A> editMetadata();
    public StorageClassFluent.MetadataNested<A> editOrNewMetadata();
    public StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToParameters(String key,String value);
    public A addToParameters(Map<String,String> map);
    public A removeFromParameters(String key);
    public A removeFromParameters(Map<String,String> map);
    public Map<String,String> getParameters();
    public A withParameters(Map<String,String> parameters);
    public Boolean hasParameters();
    public String getProvisioner();
    public A withProvisioner(String provisioner);
    public Boolean hasProvisioner();

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<StorageClassFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
