package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class PersistentVolumeClaimStatusFluentImpl<A extends PersistentVolumeClaimStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PersistentVolumeClaimStatusFluent<A>{

    private List<String> accessModes = new ArrayList<String>();
    private Map<String,Quantity> capacity = new LinkedHashMap<String,Quantity>();
    private String phase;

    public PersistentVolumeClaimStatusFluentImpl(){
    }
    public PersistentVolumeClaimStatusFluentImpl(PersistentVolumeClaimStatus instance){
            this.withAccessModes(instance.getAccessModes()); 
            this.withCapacity(instance.getCapacity()); 
            this.withPhase(instance.getPhase()); 
    }

    public A addToAccessModes(int index,String item){
            this.accessModes.add(index, item); return (A)this;
    }

    public A setToAccessModes(int index,String item){
            this.accessModes.set(index, item); return (A)this;
    }

    public A addToAccessModes(String... items){
            for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A addAllToAccessModes(Collection<String> items){
            for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A removeFromAccessModes(String... items){
            for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }

    public A removeAllFromAccessModes(Collection<String> items){
            for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }

    public List<String> getAccessModes(){
            return this.accessModes;
    }

    public String getAccessMode(int index){
            return this.accessModes.get(index);
    }

    public String getFirstAccessMode(){
            return this.accessModes.get(0);
    }

    public String getLastAccessMode(){
            return this.accessModes.get(accessModes.size() - 1);
    }

    public String getMatchingAccessMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: accessModes) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAccessModes(List<String> accessModes){
            this.accessModes.clear();
            if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (A) this;
    }

    public A withAccessModes(String... accessModes){
            this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }

    public Boolean hasAccessModes(){
            return accessModes!= null && !accessModes.isEmpty();
    }

    public A addToCapacity(String key,Quantity value){
            if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }

    public A addToCapacity(Map<String,Quantity> map){
            if(map != null) { this.capacity.putAll(map);} return (A)this;
    }

    public A removeFromCapacity(String key){
            if(key != null) {this.capacity.remove(key);} return (A)this;
    }

    public A removeFromCapacity(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getCapacity(){
            return this.capacity;
    }

    public A withCapacity(Map<String,Quantity> capacity){
            this.capacity.clear();
            if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }

    public Boolean hasCapacity(){
            return this.capacity!=null;
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeClaimStatusFluentImpl that = (PersistentVolumeClaimStatusFluentImpl) o;
            if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
            if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            return true;
    }




}
