package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Node;
import java.lang.String;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluent;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.StorageClassBuilder;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.StorageClass;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.PodTemplateBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.LimitRangeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.NodeFluent;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.model.ComponentStatusFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicy;
import io.fabric8.kubernetes.api.model.JobBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PodFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.CronJob;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.BindingFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import io.fabric8.kubernetes.api.model.StorageClassFluent;
import io.fabric8.kubernetes.api.model.LimitRangeFluent;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.CronJobFluent;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.Job;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.CronJobBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.BindingBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.extensions.Scale;

public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getDockerImageConfig();
    public A withDockerImageConfig(String dockerImageConfig);
    public Boolean hasDockerImageConfig();
    public A addToDockerImageLayers(int index,ImageLayer item);
    public A setToDockerImageLayers(int index,ImageLayer item);
    public A addToDockerImageLayers(ImageLayer... items);
    public A addAllToDockerImageLayers(Collection<ImageLayer> items);
    public A removeFromDockerImageLayers(ImageLayer... items);
    public A removeAllFromDockerImageLayers(Collection<ImageLayer> items);
    
/**
 * This method has been deprecated, please use method buildDockerImageLayers instead.
 */
@Deprecated public List<ImageLayer> getDockerImageLayers();
    public List<ImageLayer> buildDockerImageLayers();
    public ImageLayer buildDockerImageLayer(int index);
    public ImageLayer buildFirstDockerImageLayer();
    public ImageLayer buildLastDockerImageLayer();
    public ImageLayer buildMatchingDockerImageLayer(io.fabric8.kubernetes.api.builder.Predicate<ImageLayerBuilder> predicate);
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers);
    public A withDockerImageLayers(ImageLayer... dockerImageLayers);
    public Boolean hasDockerImageLayers();
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer();
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item);
    public ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(int index,ImageLayer item);
    public ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(int index);
    public ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer();
    public ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer();
    public ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(io.fabric8.kubernetes.api.builder.Predicate<ImageLayerBuilder> predicate);
    public A addNewDockerImageLayer(String mediaType,String name,Long size);
    public String getDockerImageManifest();
    public A withDockerImageManifest(String dockerImageManifest);
    public Boolean hasDockerImageManifest();
    public String getDockerImageManifestMediaType();
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType);
    public Boolean hasDockerImageManifestMediaType();
    
/**
 * This method has been deprecated, please use method buildDockerImageMetadata instead.
 */
@Deprecated public HasMetadata getDockerImageMetadata();
    public HasMetadata buildDockerImageMetadata();
    public A withDockerImageMetadata(HasMetadata dockerImageMetadata);
    public Boolean hasDockerImageMetadata();
    public A withThirdPartyResourceDockerImageMetadata(ThirdPartyResource thirdPartyResourceDockerImageMetadata);
    public ImageFluent.ThirdPartyResourceDockerImageMetadataNested<A> withNewThirdPartyResourceDockerImageMetadata();
    public ImageFluent.ThirdPartyResourceDockerImageMetadataNested<A> withNewThirdPartyResourceDockerImageMetadataLike(ThirdPartyResource item);
    public A withRouteDockerImageMetadata(Route routeDockerImageMetadata);
    public ImageFluent.RouteDockerImageMetadataNested<A> withNewRouteDockerImageMetadata();
    public ImageFluent.RouteDockerImageMetadataNested<A> withNewRouteDockerImageMetadataLike(Route item);
    public A withNamespaceDockerImageMetadata(Namespace namespaceDockerImageMetadata);
    public ImageFluent.NamespaceDockerImageMetadataNested<A> withNewNamespaceDockerImageMetadata();
    public ImageFluent.NamespaceDockerImageMetadataNested<A> withNewNamespaceDockerImageMetadataLike(Namespace item);
    public A withServiceDockerImageMetadata(Service serviceDockerImageMetadata);
    public ImageFluent.ServiceDockerImageMetadataNested<A> withNewServiceDockerImageMetadata();
    public ImageFluent.ServiceDockerImageMetadataNested<A> withNewServiceDockerImageMetadataLike(Service item);
    public A withReplicationControllerDockerImageMetadata(ReplicationController replicationControllerDockerImageMetadata);
    public ImageFluent.ReplicationControllerDockerImageMetadataNested<A> withNewReplicationControllerDockerImageMetadata();
    public ImageFluent.ReplicationControllerDockerImageMetadataNested<A> withNewReplicationControllerDockerImageMetadataLike(ReplicationController item);
    public A withHorizontalPodAutoscalerDockerImageMetadata(HorizontalPodAutoscaler horizontalPodAutoscalerDockerImageMetadata);
    public ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<A> withNewHorizontalPodAutoscalerDockerImageMetadata();
    public ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<A> withNewHorizontalPodAutoscalerDockerImageMetadataLike(HorizontalPodAutoscaler item);
    public A withScaleDockerImageMetadata(Scale scaleDockerImageMetadata);
    public ImageFluent.ScaleDockerImageMetadataNested<A> withNewScaleDockerImageMetadata();
    public ImageFluent.ScaleDockerImageMetadataNested<A> withNewScaleDockerImageMetadataLike(Scale item);
    public A withNetworkPolicyDockerImageMetadata(NetworkPolicy networkPolicyDockerImageMetadata);
    public ImageFluent.NetworkPolicyDockerImageMetadataNested<A> withNewNetworkPolicyDockerImageMetadata();
    public ImageFluent.NetworkPolicyDockerImageMetadataNested<A> withNewNetworkPolicyDockerImageMetadataLike(NetworkPolicy item);
    public A withImageDockerImageMetadata(Image imageDockerImageMetadata);
    public ImageFluent.ImageDockerImageMetadataNested<A> withNewImageDockerImageMetadata();
    public ImageFluent.ImageDockerImageMetadataNested<A> withNewImageDockerImageMetadataLike(Image item);
    public A withStorageClassDockerImageMetadata(StorageClass storageClassDockerImageMetadata);
    public ImageFluent.StorageClassDockerImageMetadataNested<A> withNewStorageClassDockerImageMetadata();
    public ImageFluent.StorageClassDockerImageMetadataNested<A> withNewStorageClassDockerImageMetadataLike(StorageClass item);
    public A withReplicaSetDockerImageMetadata(ReplicaSet replicaSetDockerImageMetadata);
    public ImageFluent.ReplicaSetDockerImageMetadataNested<A> withNewReplicaSetDockerImageMetadata();
    public ImageFluent.ReplicaSetDockerImageMetadataNested<A> withNewReplicaSetDockerImageMetadataLike(ReplicaSet item);
    public A withEndpointsDockerImageMetadata(Endpoints endpointsDockerImageMetadata);
    public ImageFluent.EndpointsDockerImageMetadataNested<A> withNewEndpointsDockerImageMetadata();
    public ImageFluent.EndpointsDockerImageMetadataNested<A> withNewEndpointsDockerImageMetadataLike(Endpoints item);
    public A withPodDockerImageMetadata(Pod podDockerImageMetadata);
    public ImageFluent.PodDockerImageMetadataNested<A> withNewPodDockerImageMetadata();
    public ImageFluent.PodDockerImageMetadataNested<A> withNewPodDockerImageMetadataLike(Pod item);
    public A withConfigMapDockerImageMetadata(ConfigMap configMapDockerImageMetadata);
    public ImageFluent.ConfigMapDockerImageMetadataNested<A> withNewConfigMapDockerImageMetadata();
    public ImageFluent.ConfigMapDockerImageMetadataNested<A> withNewConfigMapDockerImageMetadataLike(ConfigMap item);
    public A withCustomResourceDefinitionDockerImageMetadata(CustomResourceDefinition customResourceDefinitionDockerImageMetadata);
    public ImageFluent.CustomResourceDefinitionDockerImageMetadataNested<A> withNewCustomResourceDefinitionDockerImageMetadata();
    public ImageFluent.CustomResourceDefinitionDockerImageMetadataNested<A> withNewCustomResourceDefinitionDockerImageMetadataLike(CustomResourceDefinition item);
    public A withClusterPolicyDockerImageMetadata(ClusterPolicy clusterPolicyDockerImageMetadata);
    public ImageFluent.ClusterPolicyDockerImageMetadataNested<A> withNewClusterPolicyDockerImageMetadata();
    public ImageFluent.ClusterPolicyDockerImageMetadataNested<A> withNewClusterPolicyDockerImageMetadataLike(ClusterPolicy item);
    public A withDaemonSetDockerImageMetadata(DaemonSet daemonSetDockerImageMetadata);
    public ImageFluent.DaemonSetDockerImageMetadataNested<A> withNewDaemonSetDockerImageMetadata();
    public ImageFluent.DaemonSetDockerImageMetadataNested<A> withNewDaemonSetDockerImageMetadataLike(DaemonSet item);
    public A withBuildDockerImageMetadata(Build buildDockerImageMetadata);
    public ImageFluent.BuildDockerImageMetadataNested<A> withNewBuildDockerImageMetadata();
    public ImageFluent.BuildDockerImageMetadataNested<A> withNewBuildDockerImageMetadataLike(Build item);
    public A withImageStreamTagDockerImageMetadata(ImageStreamTag imageStreamTagDockerImageMetadata);
    public ImageFluent.ImageStreamTagDockerImageMetadataNested<A> withNewImageStreamTagDockerImageMetadata();
    public ImageFluent.ImageStreamTagDockerImageMetadataNested<A> withNewImageStreamTagDockerImageMetadataLike(ImageStreamTag item);
    public A withGroupDockerImageMetadata(Group groupDockerImageMetadata);
    public ImageFluent.GroupDockerImageMetadataNested<A> withNewGroupDockerImageMetadata();
    public ImageFluent.GroupDockerImageMetadataNested<A> withNewGroupDockerImageMetadataLike(Group item);
    public A withImageSignatureDockerImageMetadata(ImageSignature imageSignatureDockerImageMetadata);
    public ImageFluent.ImageSignatureDockerImageMetadataNested<A> withNewImageSignatureDockerImageMetadata();
    public ImageFluent.ImageSignatureDockerImageMetadataNested<A> withNewImageSignatureDockerImageMetadataLike(ImageSignature item);
    public A withResourceQuotaDockerImageMetadata(ResourceQuota resourceQuotaDockerImageMetadata);
    public ImageFluent.ResourceQuotaDockerImageMetadataNested<A> withNewResourceQuotaDockerImageMetadata();
    public ImageFluent.ResourceQuotaDockerImageMetadataNested<A> withNewResourceQuotaDockerImageMetadataLike(ResourceQuota item);
    public A withBuildRequestDockerImageMetadata(BuildRequest buildRequestDockerImageMetadata);
    public ImageFluent.BuildRequestDockerImageMetadataNested<A> withNewBuildRequestDockerImageMetadata();
    public ImageFluent.BuildRequestDockerImageMetadataNested<A> withNewBuildRequestDockerImageMetadataLike(BuildRequest item);
    public A withImageStreamDockerImageMetadata(ImageStream imageStreamDockerImageMetadata);
    public ImageFluent.ImageStreamDockerImageMetadataNested<A> withNewImageStreamDockerImageMetadata();
    public ImageFluent.ImageStreamDockerImageMetadataNested<A> withNewImageStreamDockerImageMetadataLike(ImageStream item);
    public A withOAuthClientDockerImageMetadata(OAuthClient oAuthClientDockerImageMetadata);
    public ImageFluent.OAuthClientDockerImageMetadataNested<A> withNewOAuthClientDockerImageMetadata();
    public ImageFluent.OAuthClientDockerImageMetadataNested<A> withNewOAuthClientDockerImageMetadataLike(OAuthClient item);
    public A withIdentityDockerImageMetadata(Identity identityDockerImageMetadata);
    public ImageFluent.IdentityDockerImageMetadataNested<A> withNewIdentityDockerImageMetadata();
    public ImageFluent.IdentityDockerImageMetadataNested<A> withNewIdentityDockerImageMetadataLike(Identity item);
    public A withLimitRangeDockerImageMetadata(LimitRange limitRangeDockerImageMetadata);
    public ImageFluent.LimitRangeDockerImageMetadataNested<A> withNewLimitRangeDockerImageMetadata();
    public ImageFluent.LimitRangeDockerImageMetadataNested<A> withNewLimitRangeDockerImageMetadataLike(LimitRange item);
    public A withJobDockerImageMetadata(Job jobDockerImageMetadata);
    public ImageFluent.JobDockerImageMetadataNested<A> withNewJobDockerImageMetadata();
    public ImageFluent.JobDockerImageMetadataNested<A> withNewJobDockerImageMetadataLike(Job item);
    public A withProjectDockerImageMetadata(Project projectDockerImageMetadata);
    public ImageFluent.ProjectDockerImageMetadataNested<A> withNewProjectDockerImageMetadata();
    public ImageFluent.ProjectDockerImageMetadataNested<A> withNewProjectDockerImageMetadataLike(Project item);
    public A withBuildConfigDockerImageMetadata(BuildConfig buildConfigDockerImageMetadata);
    public ImageFluent.BuildConfigDockerImageMetadataNested<A> withNewBuildConfigDockerImageMetadata();
    public ImageFluent.BuildConfigDockerImageMetadataNested<A> withNewBuildConfigDockerImageMetadataLike(BuildConfig item);
    public A withOAuthAuthorizeTokenDockerImageMetadata(OAuthAuthorizeToken oAuthAuthorizeTokenDockerImageMetadata);
    public ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<A> withNewOAuthAuthorizeTokenDockerImageMetadata();
    public ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<A> withNewOAuthAuthorizeTokenDockerImageMetadataLike(OAuthAuthorizeToken item);
    public A withClusterRoleBindingDockerImageMetadata(ClusterRoleBinding clusterRoleBindingDockerImageMetadata);
    public ImageFluent.ClusterRoleBindingDockerImageMetadataNested<A> withNewClusterRoleBindingDockerImageMetadata();
    public ImageFluent.ClusterRoleBindingDockerImageMetadataNested<A> withNewClusterRoleBindingDockerImageMetadataLike(ClusterRoleBinding item);
    public A withProjectRequestDockerImageMetadata(ProjectRequest projectRequestDockerImageMetadata);
    public ImageFluent.ProjectRequestDockerImageMetadataNested<A> withNewProjectRequestDockerImageMetadata();
    public ImageFluent.ProjectRequestDockerImageMetadataNested<A> withNewProjectRequestDockerImageMetadataLike(ProjectRequest item);
    public A withTemplateDockerImageMetadata(Template templateDockerImageMetadata);
    public ImageFluent.TemplateDockerImageMetadataNested<A> withNewTemplateDockerImageMetadata();
    public ImageFluent.TemplateDockerImageMetadataNested<A> withNewTemplateDockerImageMetadataLike(Template item);
    public A withOAuthClientAuthorizationDockerImageMetadata(OAuthClientAuthorization oAuthClientAuthorizationDockerImageMetadata);
    public ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<A> withNewOAuthClientAuthorizationDockerImageMetadata();
    public ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<A> withNewOAuthClientAuthorizationDockerImageMetadataLike(OAuthClientAuthorization item);
    public A withPolicyBindingDockerImageMetadata(PolicyBinding policyBindingDockerImageMetadata);
    public ImageFluent.PolicyBindingDockerImageMetadataNested<A> withNewPolicyBindingDockerImageMetadata();
    public ImageFluent.PolicyBindingDockerImageMetadataNested<A> withNewPolicyBindingDockerImageMetadataLike(PolicyBinding item);
    public A withClusterRoleDockerImageMetadata(ClusterRole clusterRoleDockerImageMetadata);
    public ImageFluent.ClusterRoleDockerImageMetadataNested<A> withNewClusterRoleDockerImageMetadata();
    public ImageFluent.ClusterRoleDockerImageMetadataNested<A> withNewClusterRoleDockerImageMetadataLike(ClusterRole item);
    public A withPodTemplateDockerImageMetadata(PodTemplate podTemplateDockerImageMetadata);
    public ImageFluent.PodTemplateDockerImageMetadataNested<A> withNewPodTemplateDockerImageMetadata();
    public ImageFluent.PodTemplateDockerImageMetadataNested<A> withNewPodTemplateDockerImageMetadataLike(PodTemplate item);
    public A withEventDockerImageMetadata(Event eventDockerImageMetadata);
    public ImageFluent.EventDockerImageMetadataNested<A> withNewEventDockerImageMetadata();
    public ImageFluent.EventDockerImageMetadataNested<A> withNewEventDockerImageMetadataLike(Event item);
    public A withIngressDockerImageMetadata(Ingress ingressDockerImageMetadata);
    public ImageFluent.IngressDockerImageMetadataNested<A> withNewIngressDockerImageMetadata();
    public ImageFluent.IngressDockerImageMetadataNested<A> withNewIngressDockerImageMetadataLike(Ingress item);
    public A withDeploymentConfigDockerImageMetadata(DeploymentConfig deploymentConfigDockerImageMetadata);
    public ImageFluent.DeploymentConfigDockerImageMetadataNested<A> withNewDeploymentConfigDockerImageMetadata();
    public ImageFluent.DeploymentConfigDockerImageMetadataNested<A> withNewDeploymentConfigDockerImageMetadataLike(DeploymentConfig item);
    public A withOAuthAccessTokenDockerImageMetadata(OAuthAccessToken oAuthAccessTokenDockerImageMetadata);
    public ImageFluent.OAuthAccessTokenDockerImageMetadataNested<A> withNewOAuthAccessTokenDockerImageMetadata();
    public ImageFluent.OAuthAccessTokenDockerImageMetadataNested<A> withNewOAuthAccessTokenDockerImageMetadataLike(OAuthAccessToken item);
    public A withRoleBindingDockerImageMetadata(RoleBinding roleBindingDockerImageMetadata);
    public ImageFluent.RoleBindingDockerImageMetadataNested<A> withNewRoleBindingDockerImageMetadata();
    public ImageFluent.RoleBindingDockerImageMetadataNested<A> withNewRoleBindingDockerImageMetadataLike(RoleBinding item);
    public A withPersistentVolumeDockerImageMetadata(PersistentVolume persistentVolumeDockerImageMetadata);
    public ImageFluent.PersistentVolumeDockerImageMetadataNested<A> withNewPersistentVolumeDockerImageMetadata();
    public ImageFluent.PersistentVolumeDockerImageMetadataNested<A> withNewPersistentVolumeDockerImageMetadataLike(PersistentVolume item);
    public A withPersistentVolumeClaimDockerImageMetadata(PersistentVolumeClaim persistentVolumeClaimDockerImageMetadata);
    public ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<A> withNewPersistentVolumeClaimDockerImageMetadata();
    public ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<A> withNewPersistentVolumeClaimDockerImageMetadataLike(PersistentVolumeClaim item);
    public A withCronJobDockerImageMetadata(CronJob cronJobDockerImageMetadata);
    public ImageFluent.CronJobDockerImageMetadataNested<A> withNewCronJobDockerImageMetadata();
    public ImageFluent.CronJobDockerImageMetadataNested<A> withNewCronJobDockerImageMetadataLike(CronJob item);
    public A withRoleDockerImageMetadata(Role roleDockerImageMetadata);
    public ImageFluent.RoleDockerImageMetadataNested<A> withNewRoleDockerImageMetadata();
    public ImageFluent.RoleDockerImageMetadataNested<A> withNewRoleDockerImageMetadataLike(Role item);
    public A withDeploymentDockerImageMetadata(Deployment deploymentDockerImageMetadata);
    public ImageFluent.DeploymentDockerImageMetadataNested<A> withNewDeploymentDockerImageMetadata();
    public ImageFluent.DeploymentDockerImageMetadataNested<A> withNewDeploymentDockerImageMetadataLike(Deployment item);
    public A withUserDockerImageMetadata(User userDockerImageMetadata);
    public ImageFluent.UserDockerImageMetadataNested<A> withNewUserDockerImageMetadata();
    public ImageFluent.UserDockerImageMetadataNested<A> withNewUserDockerImageMetadataLike(User item);
    public A withComponentStatusDockerImageMetadata(ComponentStatus componentStatusDockerImageMetadata);
    public ImageFluent.ComponentStatusDockerImageMetadataNested<A> withNewComponentStatusDockerImageMetadata();
    public ImageFluent.ComponentStatusDockerImageMetadataNested<A> withNewComponentStatusDockerImageMetadataLike(ComponentStatus item);
    public A withRoleBindingRestrictionDockerImageMetadata(RoleBindingRestriction roleBindingRestrictionDockerImageMetadata);
    public ImageFluent.RoleBindingRestrictionDockerImageMetadataNested<A> withNewRoleBindingRestrictionDockerImageMetadata();
    public ImageFluent.RoleBindingRestrictionDockerImageMetadataNested<A> withNewRoleBindingRestrictionDockerImageMetadataLike(RoleBindingRestriction item);
    public A withTokenReviewDockerImageMetadata(TokenReview tokenReviewDockerImageMetadata);
    public ImageFluent.TokenReviewDockerImageMetadataNested<A> withNewTokenReviewDockerImageMetadata();
    public ImageFluent.TokenReviewDockerImageMetadataNested<A> withNewTokenReviewDockerImageMetadataLike(TokenReview item);
    public A withPolicyDockerImageMetadata(Policy policyDockerImageMetadata);
    public ImageFluent.PolicyDockerImageMetadataNested<A> withNewPolicyDockerImageMetadata();
    public ImageFluent.PolicyDockerImageMetadataNested<A> withNewPolicyDockerImageMetadataLike(Policy item);
    public A withBindingDockerImageMetadata(Binding bindingDockerImageMetadata);
    public ImageFluent.BindingDockerImageMetadataNested<A> withNewBindingDockerImageMetadata();
    public ImageFluent.BindingDockerImageMetadataNested<A> withNewBindingDockerImageMetadataLike(Binding item);
    public A withSecretDockerImageMetadata(Secret secretDockerImageMetadata);
    public ImageFluent.SecretDockerImageMetadataNested<A> withNewSecretDockerImageMetadata();
    public ImageFluent.SecretDockerImageMetadataNested<A> withNewSecretDockerImageMetadataLike(Secret item);
    public A withSecurityContextConstraintsDockerImageMetadata(SecurityContextConstraints securityContextConstraintsDockerImageMetadata);
    public ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<A> withNewSecurityContextConstraintsDockerImageMetadata();
    public ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<A> withNewSecurityContextConstraintsDockerImageMetadataLike(SecurityContextConstraints item);
    public A withClusterPolicyBindingDockerImageMetadata(ClusterPolicyBinding clusterPolicyBindingDockerImageMetadata);
    public ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<A> withNewClusterPolicyBindingDockerImageMetadata();
    public ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<A> withNewClusterPolicyBindingDockerImageMetadataLike(ClusterPolicyBinding item);
    public A withNodeDockerImageMetadata(Node nodeDockerImageMetadata);
    public ImageFluent.NodeDockerImageMetadataNested<A> withNewNodeDockerImageMetadata();
    public ImageFluent.NodeDockerImageMetadataNested<A> withNewNodeDockerImageMetadataLike(Node item);
    public A withStatefulSetDockerImageMetadata(StatefulSet statefulSetDockerImageMetadata);
    public ImageFluent.StatefulSetDockerImageMetadataNested<A> withNewStatefulSetDockerImageMetadata();
    public ImageFluent.StatefulSetDockerImageMetadataNested<A> withNewStatefulSetDockerImageMetadataLike(StatefulSet item);
    public A withServiceAccountDockerImageMetadata(ServiceAccount serviceAccountDockerImageMetadata);
    public ImageFluent.ServiceAccountDockerImageMetadataNested<A> withNewServiceAccountDockerImageMetadata();
    public ImageFluent.ServiceAccountDockerImageMetadataNested<A> withNewServiceAccountDockerImageMetadataLike(ServiceAccount item);
    public String getDockerImageMetadataVersion();
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion);
    public Boolean hasDockerImageMetadataVersion();
    public String getDockerImageReference();
    public A withDockerImageReference(String dockerImageReference);
    public Boolean hasDockerImageReference();
    public A addToDockerImageSignatures(int index,String item);
    public A setToDockerImageSignatures(int index,String item);
    public A addToDockerImageSignatures(String... items);
    public A addAllToDockerImageSignatures(Collection<String> items);
    public A removeFromDockerImageSignatures(String... items);
    public A removeAllFromDockerImageSignatures(Collection<String> items);
    public List<String> getDockerImageSignatures();
    public String getDockerImageSignature(int index);
    public String getFirstDockerImageSignature();
    public String getLastDockerImageSignature();
    public String getMatchingDockerImageSignature(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDockerImageSignatures(List<String> dockerImageSignatures);
    public A withDockerImageSignatures(String... dockerImageSignatures);
    public Boolean hasDockerImageSignatures();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ImageFluent.MetadataNested<A> withNewMetadata();
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageFluent.MetadataNested<A> editMetadata();
    public ImageFluent.MetadataNested<A> editOrNewMetadata();
    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSignatures(int index,ImageSignature item);
    public A setToSignatures(int index,ImageSignature item);
    public A addToSignatures(ImageSignature... items);
    public A addAllToSignatures(Collection<ImageSignature> items);
    public A removeFromSignatures(ImageSignature... items);
    public A removeAllFromSignatures(Collection<ImageSignature> items);
    
/**
 * This method has been deprecated, please use method buildSignatures instead.
 */
@Deprecated public List<ImageSignature> getSignatures();
    public List<ImageSignature> buildSignatures();
    public ImageSignature buildSignature(int index);
    public ImageSignature buildFirstSignature();
    public ImageSignature buildLastSignature();
    public ImageSignature buildMatchingSignature(io.fabric8.kubernetes.api.builder.Predicate<ImageSignatureBuilder> predicate);
    public A withSignatures(List<ImageSignature> signatures);
    public A withSignatures(ImageSignature... signatures);
    public Boolean hasSignatures();
    public ImageFluent.SignaturesNested<A> addNewSignature();
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item);
    public ImageFluent.SignaturesNested<A> setNewSignatureLike(int index,ImageSignature item);
    public ImageFluent.SignaturesNested<A> editSignature(int index);
    public ImageFluent.SignaturesNested<A> editFirstSignature();
    public ImageFluent.SignaturesNested<A> editLastSignature();
    public ImageFluent.SignaturesNested<A> editMatchingSignature(io.fabric8.kubernetes.api.builder.Predicate<ImageSignatureBuilder> predicate);

    public interface DockerImageLayersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageLayerFluent<ImageFluent.DockerImageLayersNested<N>>{

        
    public N and();    public N endDockerImageLayer();
}
    public interface ThirdPartyResourceDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ThirdPartyResourceFluent<ImageFluent.ThirdPartyResourceDockerImageMetadataNested<N>>{

        
    public N and();    public N endThirdPartyResourceDockerImageMetadata();
}
    public interface RouteDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<ImageFluent.RouteDockerImageMetadataNested<N>>{

        
    public N and();    public N endRouteDockerImageMetadata();
}
    public interface NamespaceDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceFluent<ImageFluent.NamespaceDockerImageMetadataNested<N>>{

        
    public N and();    public N endNamespaceDockerImageMetadata();
}
    public interface ServiceDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceFluent<ImageFluent.ServiceDockerImageMetadataNested<N>>{

        
    public N and();    public N endServiceDockerImageMetadata();
}
    public interface ReplicationControllerDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicationControllerFluent<ImageFluent.ReplicationControllerDockerImageMetadataNested<N>>{

        
    public N and();    public N endReplicationControllerDockerImageMetadata();
}
    public interface HorizontalPodAutoscalerDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HorizontalPodAutoscalerFluent<ImageFluent.HorizontalPodAutoscalerDockerImageMetadataNested<N>>{

        
    public N and();    public N endHorizontalPodAutoscalerDockerImageMetadata();
}
    public interface ScaleDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScaleFluent<ImageFluent.ScaleDockerImageMetadataNested<N>>{

        
    public N and();    public N endScaleDockerImageMetadata();
}
    public interface NetworkPolicyDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyFluent<ImageFluent.NetworkPolicyDockerImageMetadataNested<N>>{

        
    public N and();    public N endNetworkPolicyDockerImageMetadata();
}
    public interface ImageDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ImageFluent.ImageDockerImageMetadataNested<N>>{

        
    public N and();    public N endImageDockerImageMetadata();
}
    public interface StorageClassDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StorageClassFluent<ImageFluent.StorageClassDockerImageMetadataNested<N>>{

        
    public N and();    public N endStorageClassDockerImageMetadata();
}
    public interface ReplicaSetDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetFluent<ImageFluent.ReplicaSetDockerImageMetadataNested<N>>{

        
    public N and();    public N endReplicaSetDockerImageMetadata();
}
    public interface EndpointsDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointsFluent<ImageFluent.EndpointsDockerImageMetadataNested<N>>{

        
    public N and();    public N endEndpointsDockerImageMetadata();
}
    public interface PodDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodFluent<ImageFluent.PodDockerImageMetadataNested<N>>{

        
    public N and();    public N endPodDockerImageMetadata();
}
    public interface ConfigMapDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapFluent<ImageFluent.ConfigMapDockerImageMetadataNested<N>>{

        
    public N and();    public N endConfigMapDockerImageMetadata();
}
    public interface CustomResourceDefinitionDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CustomResourceDefinitionFluent<ImageFluent.CustomResourceDefinitionDockerImageMetadataNested<N>>{

        
    public N and();    public N endCustomResourceDefinitionDockerImageMetadata();
}
    public interface ClusterPolicyDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterPolicyFluent<ImageFluent.ClusterPolicyDockerImageMetadataNested<N>>{

        
    public N and();    public N endClusterPolicyDockerImageMetadata();
}
    public interface DaemonSetDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetFluent<ImageFluent.DaemonSetDockerImageMetadataNested<N>>{

        
    public N and();    public N endDaemonSetDockerImageMetadata();
}
    public interface BuildDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<ImageFluent.BuildDockerImageMetadataNested<N>>{

        
    public N and();    public N endBuildDockerImageMetadata();
}
    public interface ImageStreamTagDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<ImageFluent.ImageStreamTagDockerImageMetadataNested<N>>{

        
    public N and();    public N endImageStreamTagDockerImageMetadata();
}
    public interface GroupDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<ImageFluent.GroupDockerImageMetadataNested<N>>{

        
    public N and();    public N endGroupDockerImageMetadata();
}
    public interface ImageSignatureDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ImageFluent.ImageSignatureDockerImageMetadataNested<N>>{

        
    public N and();    public N endImageSignatureDockerImageMetadata();
}
    public interface ResourceQuotaDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaFluent<ImageFluent.ResourceQuotaDockerImageMetadataNested<N>>{

        
    public N and();    public N endResourceQuotaDockerImageMetadata();
}
    public interface BuildRequestDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<ImageFluent.BuildRequestDockerImageMetadataNested<N>>{

        
    public N and();    public N endBuildRequestDockerImageMetadata();
}
    public interface ImageStreamDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<ImageFluent.ImageStreamDockerImageMetadataNested<N>>{

        
    public N and();    public N endImageStreamDockerImageMetadata();
}
    public interface OAuthClientDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<ImageFluent.OAuthClientDockerImageMetadataNested<N>>{

        
    public N and();    public N endOAuthClientDockerImageMetadata();
}
    public interface IdentityDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<ImageFluent.IdentityDockerImageMetadataNested<N>>{

        
    public N and();    public N endIdentityDockerImageMetadata();
}
    public interface LimitRangeDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LimitRangeFluent<ImageFluent.LimitRangeDockerImageMetadataNested<N>>{

        
    public N and();    public N endLimitRangeDockerImageMetadata();
}
    public interface JobDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JobFluent<ImageFluent.JobDockerImageMetadataNested<N>>{

        
    public N and();    public N endJobDockerImageMetadata();
}
    public interface ProjectDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<ImageFluent.ProjectDockerImageMetadataNested<N>>{

        
    public N and();    public N endProjectDockerImageMetadata();
}
    public interface BuildConfigDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<ImageFluent.BuildConfigDockerImageMetadataNested<N>>{

        
    public N and();    public N endBuildConfigDockerImageMetadata();
}
    public interface OAuthAuthorizeTokenDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<ImageFluent.OAuthAuthorizeTokenDockerImageMetadataNested<N>>{

        
    public N and();    public N endOAuthAuthorizeTokenDockerImageMetadata();
}
    public interface ClusterRoleBindingDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<ImageFluent.ClusterRoleBindingDockerImageMetadataNested<N>>{

        
    public N and();    public N endClusterRoleBindingDockerImageMetadata();
}
    public interface ProjectRequestDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<ImageFluent.ProjectRequestDockerImageMetadataNested<N>>{

        
    public N and();    public N endProjectRequestDockerImageMetadata();
}
    public interface TemplateDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<ImageFluent.TemplateDockerImageMetadataNested<N>>{

        
    public N and();    public N endTemplateDockerImageMetadata();
}
    public interface OAuthClientAuthorizationDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<ImageFluent.OAuthClientAuthorizationDockerImageMetadataNested<N>>{

        
    public N and();    public N endOAuthClientAuthorizationDockerImageMetadata();
}
    public interface PolicyBindingDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PolicyBindingFluent<ImageFluent.PolicyBindingDockerImageMetadataNested<N>>{

        
    public N and();    public N endPolicyBindingDockerImageMetadata();
}
    public interface ClusterRoleDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<ImageFluent.ClusterRoleDockerImageMetadataNested<N>>{

        
    public N and();    public N endClusterRoleDockerImageMetadata();
}
    public interface PodTemplateDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateFluent<ImageFluent.PodTemplateDockerImageMetadataNested<N>>{

        
    public N and();    public N endPodTemplateDockerImageMetadata();
}
    public interface EventDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventFluent<ImageFluent.EventDockerImageMetadataNested<N>>{

        
    public N and();    public N endEventDockerImageMetadata();
}
    public interface IngressDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressFluent<ImageFluent.IngressDockerImageMetadataNested<N>>{

        
    public N and();    public N endIngressDockerImageMetadata();
}
    public interface DeploymentConfigDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<ImageFluent.DeploymentConfigDockerImageMetadataNested<N>>{

        
    public N and();    public N endDeploymentConfigDockerImageMetadata();
}
    public interface OAuthAccessTokenDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<ImageFluent.OAuthAccessTokenDockerImageMetadataNested<N>>{

        
    public N and();    public N endOAuthAccessTokenDockerImageMetadata();
}
    public interface RoleBindingDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<ImageFluent.RoleBindingDockerImageMetadataNested<N>>{

        
    public N and();    public N endRoleBindingDockerImageMetadata();
}
    public interface PersistentVolumeDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeFluent<ImageFluent.PersistentVolumeDockerImageMetadataNested<N>>{

        
    public N and();    public N endPersistentVolumeDockerImageMetadata();
}
    public interface PersistentVolumeClaimDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<ImageFluent.PersistentVolumeClaimDockerImageMetadataNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimDockerImageMetadata();
}
    public interface CronJobDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CronJobFluent<ImageFluent.CronJobDockerImageMetadataNested<N>>{

        
    public N and();    public N endCronJobDockerImageMetadata();
}
    public interface RoleDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<ImageFluent.RoleDockerImageMetadataNested<N>>{

        
    public N and();    public N endRoleDockerImageMetadata();
}
    public interface DeploymentDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentFluent<ImageFluent.DeploymentDockerImageMetadataNested<N>>{

        
    public N and();    public N endDeploymentDockerImageMetadata();
}
    public interface UserDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<ImageFluent.UserDockerImageMetadataNested<N>>{

        
    public N and();    public N endUserDockerImageMetadata();
}
    public interface ComponentStatusDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ComponentStatusFluent<ImageFluent.ComponentStatusDockerImageMetadataNested<N>>{

        
    public N and();    public N endComponentStatusDockerImageMetadata();
}
    public interface RoleBindingRestrictionDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<ImageFluent.RoleBindingRestrictionDockerImageMetadataNested<N>>{

        
    public N and();    public N endRoleBindingRestrictionDockerImageMetadata();
}
    public interface TokenReviewDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TokenReviewFluent<ImageFluent.TokenReviewDockerImageMetadataNested<N>>{

        
    public N and();    public N endTokenReviewDockerImageMetadata();
}
    public interface PolicyDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PolicyFluent<ImageFluent.PolicyDockerImageMetadataNested<N>>{

        
    public N and();    public N endPolicyDockerImageMetadata();
}
    public interface BindingDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BindingFluent<ImageFluent.BindingDockerImageMetadataNested<N>>{

        
    public N and();    public N endBindingDockerImageMetadata();
}
    public interface SecretDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretFluent<ImageFluent.SecretDockerImageMetadataNested<N>>{

        
    public N and();    public N endSecretDockerImageMetadata();
}
    public interface SecurityContextConstraintsDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<ImageFluent.SecurityContextConstraintsDockerImageMetadataNested<N>>{

        
    public N and();    public N endSecurityContextConstraintsDockerImageMetadata();
}
    public interface ClusterPolicyBindingDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterPolicyBindingFluent<ImageFluent.ClusterPolicyBindingDockerImageMetadataNested<N>>{

        
    public N and();    public N endClusterPolicyBindingDockerImageMetadata();
}
    public interface NodeDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeFluent<ImageFluent.NodeDockerImageMetadataNested<N>>{

        
    public N and();    public N endNodeDockerImageMetadata();
}
    public interface StatefulSetDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatefulSetFluent<ImageFluent.StatefulSetDockerImageMetadataNested<N>>{

        
    public N and();    public N endStatefulSetDockerImageMetadata();
}
    public interface ServiceAccountDockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceAccountFluent<ImageFluent.ServiceAccountDockerImageMetadataNested<N>>{

        
    public N and();    public N endServiceAccountDockerImageMetadata();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SignaturesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ImageFluent.SignaturesNested<N>>{

        
    public N and();    public N endSignature();
}


}
