package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NamedClusterRoleBindingFluent<A extends NamedClusterRoleBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildRoleBinding instead.
 */
@Deprecated public ClusterRoleBinding getRoleBinding();
    public ClusterRoleBinding buildRoleBinding();
    public A withRoleBinding(ClusterRoleBinding roleBinding);
    public Boolean hasRoleBinding();
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding();
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(ClusterRoleBinding item);
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editRoleBinding();
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding();
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(ClusterRoleBinding item);

    public interface RoleBindingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<NamedClusterRoleBindingFluent.RoleBindingNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
