/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceFluentImpl;
import javax.validation.Validator;

public class CrossVersionObjectReferenceBuilder
extends CrossVersionObjectReferenceFluentImpl<CrossVersionObjectReferenceBuilder>
implements VisitableBuilder<CrossVersionObjectReference, CrossVersionObjectReferenceBuilder> {
    CrossVersionObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CrossVersionObjectReferenceBuilder() {
        this(true);
    }

    public CrossVersionObjectReferenceBuilder(Boolean validationEnabled) {
        this(new CrossVersionObjectReference(), validationEnabled);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CrossVersionObjectReference(), validationEnabled);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent, CrossVersionObjectReference instance) {
        this(fluent, instance, true);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent, CrossVersionObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance) {
        this(instance, (Boolean)true);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public CrossVersionObjectReferenceBuilder(Validator validator) {
        this(new CrossVersionObjectReference(), (Boolean)true);
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent, CrossVersionObjectReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CrossVersionObjectReference build() {
        CrossVersionObjectReference buildable = new CrossVersionObjectReference(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrossVersionObjectReferenceBuilder that = (CrossVersionObjectReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

