/*
 * Decompiled with CFR 0.152.
 */
package io.focuspoints.servlet;

import io.focuspoints.client.FocusPointsConfigurationProperties;
import io.focuspoints.client.TokenCreator;
import io.focuspoints.client.UrlCreator;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.lang3.StringUtils;

@WebListener
public class FocusPointsInitalizer
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        FocusPointsConfigurationProperties focusPointsConfigurationProperties = FocusPointsInitalizer.getFocusPointsConfigurationProperties(sce);
        new TokenCreator(focusPointsConfigurationProperties);
        new UrlCreator(focusPointsConfigurationProperties);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        TokenCreator.destroy();
        UrlCreator.destroy();
    }

    private static FocusPointsConfigurationProperties getFocusPointsConfigurationProperties(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        FocusPointsConfigurationProperties properties = new FocusPointsConfigurationProperties();
        FocusPointsInitalizer.setPropertyIfExists(sc, "focuspoints.url", arg_0 -> ((FocusPointsConfigurationProperties)properties).setUrl(arg_0));
        FocusPointsInitalizer.setPropertyIfExists(sc, "focuspoints.token-request-parameter-name", arg_0 -> ((FocusPointsConfigurationProperties)properties).setTokenRequestParameterName(arg_0));
        FocusPointsInitalizer.setPropertyIfExists(sc, "focuspoints.token-id", arg_0 -> ((FocusPointsConfigurationProperties)properties).setTokenId(arg_0));
        FocusPointsInitalizer.setPropertyIfExists(sc, "focuspoints.token-secret", arg_0 -> ((FocusPointsConfigurationProperties)properties).setTokenSecret(arg_0));
        return properties;
    }

    private static void setPropertyIfExists(ServletContext sc, String propertyName, Consumer<String> consumer) {
        String propertyValue = sc.getInitParameter(propertyName);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            consumer.accept(propertyValue);
        }
    }
}

