/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.MissingPrivateKeyException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;

public class RSASigner
implements Signer {
    private final Algorithm algorithm;
    private final CryptoProvider cryptoProvider;
    private final String kid;
    private final RSAPrivateKey privateKey;

    private RSASigner(Algorithm algorithm, String privateKey, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        PEM pem = PEM.decode(privateKey);
        if (pem.privateKey == null) {
            throw new MissingPrivateKeyException("The provided PEM encoded string did not contain a private key.");
        }
        this.privateKey = (RSAPrivateKey)pem.getPrivateKey();
        int keyLength = this.privateKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    public static RSASigner newSHA256Signer(String privateKey, String kid) {
        return RSASigner.newSHA256Signer(privateKey, kid, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA256Signer(String privateKey) {
        return RSASigner.newSHA256Signer(privateKey, null, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA256Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS256, privateKey, kid, cryptoProvider);
    }

    public static RSASigner newSHA256Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS256, privateKey, null, cryptoProvider);
    }

    public static RSASigner newSHA384Signer(String privateKey, String kid) {
        return RSASigner.newSHA384Signer(privateKey, kid, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA384Signer(String privateKey) {
        return RSASigner.newSHA384Signer(privateKey, null, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA384Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS384, privateKey, kid, cryptoProvider);
    }

    public static RSASigner newSHA384Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS384, privateKey, null, cryptoProvider);
    }

    public static RSASigner newSHA512Signer(String privateKey, String kid) {
        return RSASigner.newSHA512Signer(privateKey, kid, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA512Signer(String privateKey) {
        return RSASigner.newSHA512Signer(privateKey, null, new DefaultCryptoProvider());
    }

    public static RSASigner newSHA512Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS512, privateKey, kid, cryptoProvider);
    }

    public static RSASigner newSHA512Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSASigner(Algorithm.RS512, privateKey, null, cryptoProvider);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Signature signature = this.cryptoProvider.getSignatureInstance(this.algorithm.getName());
            signature.initSign(this.privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

