/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;

public class KeyUtils {
    public static int getKeyLength(Key key) {
        if (key instanceof ECKey) {
            int bytes;
            if (key instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)key;
                bytes = ecPublicKey.getW().getAffineX().toByteArray().length;
            } else {
                ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
                bytes = ecPrivateKey.getS().toByteArray().length;
            }
            if (bytes >= 63 && bytes <= 66) {
                return 521;
            }
            int mod = bytes % 8;
            if (mod >= 2) {
                bytes += 8 - mod;
            }
            return bytes / 8 * 8 * 8;
        }
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new IllegalArgumentException();
    }
}

