package com.farimarwat.composenativeadmob.nativead

import android.view.View
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.compose.ui.viewinterop.AndroidViewBinding
import com.farimarwat.composenativeadmob.databinding.NativeAdMediumBinding
import com.farimarwat.composenativeadmob.databinding.NativeAdSmallBinding
import com.google.android.gms.ads.nativead.NativeAd

@Composable
fun BannerAdAdmobSmall(loadedAd: NativeAd?) {
    AndroidViewBinding(
        modifier = Modifier.padding(start = 4.dp, top = 8.dp, end = 4.dp, bottom = 4.dp),
        factory = (NativeAdSmallBinding::inflate)
    ) {
        loadedAd?.let { nativead ->
            // Display the loaded ad
            nativead.icon?.let { icon ->
                this.adIcon.setImageDrawable(icon.drawable)
            }
            nativead.headline?.let { headline ->
                this.adHeadline.text = headline
            }
            nativead.body?.let { body ->
                this.adBody.text = body
            }
            nativead.callToAction?.let { actionbutton ->
                this.adActionbutton.text = actionbutton
                this.nativeadview.callToActionView = this.adActionbutton
            }
            this.nativeadview.setNativeAd(nativead)
        }

    }

}
@Composable
fun BannerAdAdmobMedium(loadedAd: NativeAd?) {
    AndroidViewBinding(
        modifier = Modifier.padding(start = 4.dp, top = 8.dp, end = 4.dp, bottom = 4.dp),
        factory = (NativeAdMediumBinding::inflate)
    ) {
        loadedAd?.let { nativead ->
            // Display the loaded ad
            nativead.icon?.let { icon ->
                this.adIcon.setImageDrawable(icon.drawable)
            }
            nativead.headline?.let { headline ->
                this.adHeadline.text = headline
            }
            nativead.body?.let { body ->
                this.adBody.text = body
            }
            //media
            if(nativead.mediaContent?.hasVideoContent() == true){
                this.adMedia.mediaContent = nativead.mediaContent
                this.adMedia.visibility = View.VISIBLE
            } else {
                if(nativead.images.isNotEmpty()){
                    val image = nativead.images[0]
                    this.adImage.setImageDrawable(image.drawable)
                    this.adImage.visibility = View.VISIBLE
                }
            }
            //end media
            nativead.callToAction?.let { actionbutton ->
                this.adActionbutton.text = actionbutton
                this.nativeadview.callToActionView = this.adActionbutton
            }
            this.nativeadview.setNativeAd(nativead)
        }

    }

}



