/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.jgit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import pl.project13.core.git.GitDescribeConfig;
import pl.project13.core.jgit.DescribeResult;
import pl.project13.core.jgit.JGitCommon;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.Pair;

public class DescribeCommand
extends GitCommand<DescribeResult> {
    private LogInterface log;
    private JGitCommon jGitCommon;
    private String evaluateOnCommit;
    private Optional<String> matchOption = Optional.empty();
    private int abbrev = 7;
    private boolean tagsFlag = false;
    private boolean alwaysFlag = true;
    private boolean forceLongFormat = false;
    private Optional<String> dirtyOption = Optional.empty();

    @Nonnull
    public static DescribeCommand on(String evaluateOnCommit, Repository repo, LogInterface log) {
        return new DescribeCommand(evaluateOnCommit, repo, log);
    }

    private DescribeCommand(@Nonnull String evaluateOnCommit, @Nonnull Repository repo, @Nonnull LogInterface log) {
        super(repo);
        this.evaluateOnCommit = evaluateOnCommit;
        this.jGitCommon = new JGitCommon(log);
        this.log = log;
    }

    @Nonnull
    public DescribeCommand always(boolean always) {
        this.alwaysFlag = always;
        this.log.debug(String.format("--always = %s", always));
        return this;
    }

    @Nonnull
    public DescribeCommand forceLongFormat(@Nullable Boolean forceLongFormat) {
        if (forceLongFormat != null && forceLongFormat.booleanValue()) {
            this.forceLongFormat = true;
            this.log.debug(String.format("--long = %s", true));
        }
        return this;
    }

    @Nonnull
    public DescribeCommand abbrev(@Nullable Integer n) {
        if (n != null) {
            if (n >= 41) {
                throw new IllegalArgumentException("N (commit abbrev length) must be < 41. (Was:[" + n + "])");
            }
            if (n < 0) {
                throw new IllegalArgumentException("N (commit abbrev length) must be positive! (Was [" + n + "])");
            }
            this.log.debug(String.format("--abbrev = %s", n));
            this.abbrev = n;
        }
        return this;
    }

    @Nonnull
    public DescribeCommand tags(@Nullable Boolean includeLightweightTagsInSearch) {
        if (includeLightweightTagsInSearch != null && includeLightweightTagsInSearch.booleanValue()) {
            this.tagsFlag = includeLightweightTagsInSearch;
            this.log.debug(String.format("--tags = %s", includeLightweightTagsInSearch));
        }
        return this;
    }

    public DescribeCommand tags() {
        return this.tags(true);
    }

    @Nonnull
    public DescribeCommand apply(@Nullable GitDescribeConfig config) {
        if (config != null) {
            this.always(config.isAlways());
            this.dirty(config.getDirty());
            this.abbrev(config.getAbbrev());
            this.forceLongFormat(config.getForceLongFormat());
            this.tags(config.getTags());
            this.match(config.getMatch());
        }
        return this;
    }

    @Nonnull
    public DescribeCommand dirty(@Nullable String dirtyMarker) {
        Optional<String> option = Optional.ofNullable(dirtyMarker);
        this.log.debug(String.format("--dirty = %s", option.orElse("")));
        this.dirtyOption = option;
        return this;
    }

    @Nonnull
    public DescribeCommand match(@Nullable String pattern) {
        if (!"*".equals(pattern)) {
            this.matchOption = Optional.ofNullable(pattern);
            this.log.debug(String.format("--match = %s", this.matchOption.orElse("")));
        }
        return this;
    }

    public DescribeResult call() throws GitAPIException {
        List<Object> commits;
        ObjectReader objectReader = this.repo.newObjectReader();
        String matchPattern = this.createMatchPattern();
        Map<ObjectId, List<String>> tagObjectIdToName = this.jGitCommon.findTagObjectIds(this.repo, this.tagsFlag, matchPattern);
        RevCommit evalCommit = this.findEvalCommitObjectId(this.evaluateOnCommit, this.repo);
        ObjectId evalCommitId = evalCommit.getId();
        boolean dirty = this.findDirtyState(this.repo);
        if (DescribeCommand.hasTags((ObjectId)evalCommit, tagObjectIdToName) && !this.forceLongFormat) {
            String tagName = tagObjectIdToName.get(evalCommit).iterator().next();
            this.log.info(String.format("The commit we're on is a Tag ([%s]) and forceLongFormat == false, returning.", tagName));
            return new DescribeResult(tagName, dirty, this.dirtyOption);
        }
        try {
            commits = this.jGitCommon.findCommitsUntilSomeTag(this.repo, evalCommit, tagObjectIdToName);
        }
        catch (Exception e) {
            if (this.alwaysFlag) {
                commits = Collections.emptyList();
            }
            throw e;
        }
        if (DescribeCommand.foundZeroTags(tagObjectIdToName) || commits.isEmpty()) {
            return new DescribeResult(objectReader, evalCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        int distance = this.jGitCommon.distanceBetween(this.repo, evalCommit, (RevCommit)commits.get(0));
        String tagName = tagObjectIdToName.get(commits.get(0)).iterator().next();
        Pair<Integer, String> howFarFromWhichTag = Pair.of(distance, tagName);
        return this.createDescribeResult(objectReader, evalCommitId, dirty, howFarFromWhichTag);
    }

    private DescribeResult createDescribeResult(ObjectReader objectReader, ObjectId headCommitId, boolean dirty, @Nullable Pair<Integer, String> howFarFromWhichTag) {
        if (howFarFromWhichTag == null) {
            return new DescribeResult(objectReader, headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first > 0 || this.forceLongFormat) {
            return new DescribeResult(objectReader, (String)howFarFromWhichTag.second, (Integer)howFarFromWhichTag.first, headCommitId, dirty, this.dirtyOption, this.forceLongFormat).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first == 0) {
            return new DescribeResult((String)howFarFromWhichTag.second).withCommitIdAbbrev(this.abbrev);
        }
        if (this.alwaysFlag) {
            return new DescribeResult(objectReader, headCommitId).withCommitIdAbbrev(this.abbrev);
        }
        return DescribeResult.EMPTY;
    }

    private static boolean foundZeroTags(@Nonnull Map<ObjectId, List<String>> tags) {
        return tags.isEmpty();
    }

    boolean findDirtyState(Repository repo) throws GitAPIException {
        return JGitCommon.isRepositoryInDirtyState(repo);
    }

    static boolean hasTags(ObjectId headCommit, @Nonnull Map<ObjectId, List<String>> tagObjectIdToName) {
        return tagObjectIdToName.containsKey(headCommit);
    }

    RevCommit findEvalCommitObjectId(@Nonnull String evaluateOnCommit, @Nonnull Repository repo) throws RuntimeException {
        return this.jGitCommon.findEvalCommitObjectId(evaluateOnCommit, repo);
    }

    private String createMatchPattern() {
        if (!this.matchOption.isPresent()) {
            return ".*";
        }
        return this.jGitCommon.createMatchPattern(this.matchOption.get());
    }
}

