/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.project13.core.GitCommitIdExecutionException;

public class GitDirLocator {
    final File projectBasedir;
    final boolean useNativeGit;
    final boolean shouldFailOnNoGitDirectory;

    public GitDirLocator(File projectBasedir, boolean useNativeGit, boolean shouldFailOnNoGitDirectory) {
        this.projectBasedir = projectBasedir;
        this.useNativeGit = useNativeGit;
        this.shouldFailOnNoGitDirectory = shouldFailOnNoGitDirectory;
    }

    @Nullable
    public File lookupGitDirectory(@Nonnull File manuallyConfiguredDir) throws GitCommitIdExecutionException {
        File dotGitDirectory = this.runSearch(manuallyConfiguredDir, true);
        if (this.shouldFailOnNoGitDirectory && !GitDirLocator.directoryExists(dotGitDirectory)) {
            throw new GitCommitIdExecutionException(".git directory is not found! Please specify a valid [dotGitDirectory] in your project");
        }
        if (this.useNativeGit) {
            File unresolvedGitDir;
            File parentParent;
            File parent;
            if (dotGitDirectory != null && (parent = dotGitDirectory.getParentFile()) != null && (parentParent = parent.getParentFile()) != null && parentParent.getName().equals(".git") && parent.getName().equals("modules") && (unresolvedGitDir = this.runSearch(manuallyConfiguredDir, false)) != null && unresolvedGitDir.isFile()) {
                dotGitDirectory = unresolvedGitDir;
            }
            if (dotGitDirectory != null) {
                dotGitDirectory = dotGitDirectory.getParentFile();
            }
        }
        return dotGitDirectory;
    }

    private static boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    @Nullable
    private File runSearch(@Nonnull File manuallyConfiguredDir, boolean resolveGitReferenceFile) {
        if (manuallyConfiguredDir.exists()) {
            if (manuallyConfiguredDir.isDirectory()) {
                return manuallyConfiguredDir;
            }
            if (manuallyConfiguredDir.isFile() && !resolveGitReferenceFile) {
                return manuallyConfiguredDir;
            }
            File gitDirLinkPath = this.processGitDirFile(manuallyConfiguredDir);
            if (GitDirLocator.isExistingDirectory(gitDirLinkPath)) {
                return gitDirLinkPath;
            }
        }
        return this.findProjectGitDirectory(resolveGitReferenceFile);
    }

    @Nullable
    private File findProjectGitDirectory(boolean resolveGitReferenceFile) {
        for (File basedir = this.projectBasedir; basedir != null; basedir = basedir.getParentFile()) {
            File gitdir = new File(basedir, ".git");
            if (!gitdir.exists()) continue;
            if (gitdir.isDirectory()) {
                return gitdir;
            }
            if (gitdir.isFile()) {
                if (resolveGitReferenceFile) {
                    return this.processGitDirFile(gitdir);
                }
                return gitdir;
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File processGitDirFile(@Nonnull File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            if (line == null) {
                File file2 = null;
                return file2;
            }
            String[] parts = line.split(": ");
            if (parts.length != 2 || !parts[0].equals("gitdir")) {
                File file3 = null;
                return file3;
            }
            String extractFromConfig = parts[1];
            File gitDir = GitDirLocator.resolveWorktree(new File(extractFromConfig));
            if (gitDir.isAbsolute()) {
                File file4 = gitDir;
                return file4;
            }
            File file5 = new File(file.getParentFile(), extractFromConfig);
            return file5;
        }
        catch (IOException e) {
            return null;
        }
    }

    static File resolveWorktree(File fileLocation) {
        Path parent = fileLocation.toPath().getParent();
        if (parent == null) {
            return fileLocation;
        }
        if (parent.endsWith(Path.of(".git", "worktrees"))) {
            return parent.getParent().toFile();
        }
        return fileLocation;
    }

    private static boolean isExistingDirectory(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }
}

