/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin;

import io.github.gradlenexus.publishplugin.AbstractNexusStagingRepositoryTask;
import io.github.gradlenexus.publishplugin.NexusRepository;
import io.github.gradlenexus.publishplugin.internal.DetermineStagingProfileIdKt;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptorRegistryBuildService;
import io.github.gradlenexus.publishplugin.shadow.kotlin.Metadata;
import io.github.gradlenexus.publishplugin.shadow.kotlin.jvm.internal.Intrinsics;
import io.github.gradlenexus.publishplugin.shadow.kotlin.text.Regex;
import io.github.gradlenexus.publishplugin.shadow.org.jetbrains.annotations.NotNull;
import java.net.URI;
import org.gradle.api.Incubating;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@Incubating
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/gradlenexus/publishplugin/FindStagingRepository;", "Lio/github/gradlenexus/publishplugin/AbstractNexusStagingRepositoryTask;", "()V", "descriptionRegex", "Lorg/gradle/api/provider/Property;", "", "getDescriptionRegex", "()Lorg/gradle/api/provider/Property;", "packageGroup", "getPackageGroup", "registry", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptorRegistryBuildService;", "getRegistry", "stagingRepositoryId", "getStagingRepositoryId", "findStagingRepository", "", "publish-plugin"})
public abstract class FindStagingRepository
extends AbstractNexusStagingRepositoryTask {
    @Internal
    @NotNull
    public abstract Property<StagingRepositoryDescriptorRegistryBuildService> getRegistry();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getPackageGroup();

    @Input
    @NotNull
    public abstract Property<String> getDescriptionRegex();

    @Internal
    @NotNull
    public abstract Property<String> getStagingRepositoryId();

    @TaskAction
    public final void findStagingRepository() {
        String descriptionRegex;
        NexusRepository repository = (NexusRepository)this.getRepository().get();
        URI serverUrl = (URI)repository.getNexusUrl().get();
        NexusClient client = this.createNexusClient();
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull(logger, "logger");
        NexusRepository nexusRepository = repository;
        Intrinsics.checkExpressionValueIsNotNull(nexusRepository, "repository");
        Object object = this.getPackageGroup().get();
        Intrinsics.checkExpressionValueIsNotNull(object, "packageGroup.get()");
        String stagingProfileId = DetermineStagingProfileIdKt.determineStagingProfileId(client, logger, nexusRepository, (String)object);
        this.getLogger().info("Fetching staging repositories for {} at {}, stagingProfileId '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId});
        String string = descriptionRegex = (String)this.getDescriptionRegex().get();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptionRegex");
        StagingRepositoryDescriptor descriptor = client.findStagingRepository(stagingProfileId, new Regex(string));
        this.getLogger().lifecycle("Staging repository for {} at {}, stagingProfileId '{}', descriptionRegex '{}' is '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId, descriptionRegex, descriptor.getStagingRepositoryId()});
        this.getStagingRepositoryId().set((Object)descriptor.getStagingRepositoryId());
        ((StagingRepositoryDescriptorRegistryBuildService)this.getRegistry().get()).getRegistry().set(repository.getName(), descriptor);
    }

    public FindStagingRepository() {
        this.getOutputs().cacheIf("the task requests data from the external repository, so we don't want to cache it", (Spec)1.INSTANCE);
    }
}

