/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.internal;

import io.github.gradlenexus.publishplugin.internal.StagingRepository;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.shadow.kotlin.Metadata;
import io.github.gradlenexus.publishplugin.shadow.kotlin.Unit;
import io.github.gradlenexus.publishplugin.shadow.kotlin.collections.CollectionsKt;
import io.github.gradlenexus.publishplugin.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.gradlenexus.publishplugin.shadow.kotlin.jvm.internal.Intrinsics;
import io.github.gradlenexus.publishplugin.shadow.kotlin.jvm.internal.SourceDebugExtension;
import io.github.gradlenexus.publishplugin.shadow.kotlin.text.Regex;
import io.github.gradlenexus.publishplugin.shadow.kotlin.text.StringsKt;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Credentials;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Interceptor;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.OkHttpClient;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Response;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.ResponseBody;
import io.github.gradlenexus.publishplugin.shadow.org.jetbrains.annotations.NotNull;
import io.github.gradlenexus.publishplugin.shadow.org.jetbrains.annotations.Nullable;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Call;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Retrofit;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.converter.gson.GsonConverterFactory;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Body;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.GET;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Headers;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.POST;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Path;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0007\"#$%&'(B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J \u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "", "baseUrl", "Ljava/net/URI;", "username", "", "password", "timeout", "Ljava/time/Duration;", "connectTimeout", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)V", "api", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi;", "closeStagingRepository", "", "stagingRepositoryId", "description", "createStagingRepository", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptor;", "stagingProfileId", "failure", "Ljava/lang/RuntimeException;", "Lio/github/gradlenexus/publishplugin/shadow/kotlin/RuntimeException;", "action", "response", "Lio/github/gradlenexus/publishplugin/shadow/retrofit2/Response;", "findStagingProfileId", "packageGroup", "findStagingRepository", "descriptionRegex", "Lio/github/gradlenexus/publishplugin/shadow/kotlin/text/Regex;", "getStagingRepositoryStateById", "Lio/github/gradlenexus/publishplugin/internal/StagingRepository;", "releaseStagingRepository", "CreatedStagingRepository", "Description", "Dto", "NexusApi", "ReadStagingRepository", "StagingProfile", "StagingRepositoryToTransit", "publish-plugin"})
@SourceDebugExtension(value={"SMAP\nNexusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NexusClient.kt\nio/github/gradlenexus/publishplugin/internal/NexusClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _CollectionsJvm.kt\nkotlin/collections/CollectionsKt___CollectionsJvmKt\n*L\n1#1,223:1\n766#2:224\n857#2,2:225\n1963#2,14:228\n766#2:242\n857#2,2:243\n89#3:227\n*E\n*S KotlinDebug\n*F\n+ 1 NexusClient.kt\nio/github/gradlenexus/publishplugin/internal/NexusClient\n*L\n81#1:224\n81#1,2:225\n90#1,14:228\n103#1:242\n103#1,2:243\n90#1:227\n*E\n"})
public class NexusClient {
    private final NexusApi api;
    private final URI baseUrl;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String findStagingProfileId(@NotNull String packageGroup) {
        Object v4;
        void $this$filterTo$iv$iv;
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<StagingProfile>>> response;
        Intrinsics.checkParameterIsNotNull(packageGroup, "packageGroup");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<StagingProfile>>> response2 = response = this.api.getStagingProfiles().execute();
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("load staging profiles", response);
        }
        Dto<List<StagingProfile>> dto = response.body();
        Object object = dto;
        if (dto == null) return null;
        List<StagingProfile> list = ((Dto)object).getData();
        object = list;
        if (list == null) return null;
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StagingProfile profile = (StagingProfile)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default(packageGroup, profile.getName(), false, 2, null) && (packageGroup.length() == profile.getName().length() || packageGroup.charAt(profile.getName().length()) == '.'))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterable $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v4 = maxElem$iv$iv;
            } else {
                StagingProfile it = (StagingProfile)maxElem$iv$iv;
                boolean bl = false;
                int maxValue$iv$iv = it.getName().length();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    StagingProfile it2 = (StagingProfile)e$iv$iv;
                    $i$a$-maxBy-NexusClient$findStagingProfileId$2 = false;
                    int v$iv$iv = it2.getName().length();
                    if (maxValue$iv$iv >= v$iv$iv) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v4 = maxElem$iv$iv;
            }
        }
        StagingProfile stagingProfile = v4;
        object = stagingProfile;
        if (stagingProfile == null) return null;
        String string = ((StagingProfile)object).getId();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StagingRepositoryDescriptor findStagingRepository(@NotNull String stagingProfileId, @NotNull Regex descriptionRegex) {
        void $this$filterTo$iv$iv;
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<ReadStagingRepository>>> response;
        Intrinsics.checkParameterIsNotNull(stagingProfileId, "stagingProfileId");
        Intrinsics.checkParameterIsNotNull(descriptionRegex, "descriptionRegex");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<ReadStagingRepository>>> response2 = response = this.api.getStagingRepositories(stagingProfileId).execute();
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("find staging repository, stagingProfileId: " + stagingProfileId, response);
        }
        Dto<List<ReadStagingRepository>> dto = response.body();
        List<ReadStagingRepository> data = dto != null ? dto.getData() : null;
        Collection collection = data;
        if (collection == null || collection.isEmpty()) {
            throw (Throwable)new NoSuchElementException("No staging repositories found for stagingProfileId: " + stagingProfileId);
        }
        Iterable $this$filter$iv = data;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            Regex regex;
            ReadStagingRepository it = (ReadStagingRepository)element$iv$iv;
            boolean bl = false;
            String string = it.getDescription();
            if (!(string != null && (regex = descriptionRegex).containsMatchIn(charSequence = (CharSequence)string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingRepositories = (List)destination$iv$iv;
        if (matchingRepositories.isEmpty()) {
            throw (Throwable)new NoSuchElementException("No staging repositories found for stagingProfileId: " + stagingProfileId + ", descriptionRegex: " + descriptionRegex + ". " + "Here are all the repositories: " + data);
        }
        if (matchingRepositories.size() > 1) {
            throw (Throwable)new IllegalStateException("Too many repositories found for stagingProfileId: " + stagingProfileId + ", descriptionRegex: " + descriptionRegex + ". " + "If some of the repositories are not needed, consider deleting them manually. " + "Here are the repositories matching the regular expression: " + matchingRepositories);
        }
        return new StagingRepositoryDescriptor(this.baseUrl, ((ReadStagingRepository)CollectionsKt.first(matchingRepositories)).getRepositoryId());
    }

    @NotNull
    public final StagingRepositoryDescriptor createStagingRepository(@NotNull String stagingProfileId, @NotNull String description) {
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<CreatedStagingRepository>> response;
        Intrinsics.checkParameterIsNotNull(stagingProfileId, "stagingProfileId");
        Intrinsics.checkParameterIsNotNull(description, "description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<CreatedStagingRepository>> response2 = response = this.api.startStagingRepo(stagingProfileId, new Dto<Description>(new Description(description))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("create staging repository", response);
        }
        Dto<CreatedStagingRepository> dto = response.body();
        if (dto == null || (dto = dto.getData()) == null || (dto = ((CreatedStagingRepository)((Object)dto)).getStagedRepositoryId()) == null) {
            throw (Throwable)new RuntimeException("No response body");
        }
        Dto<CreatedStagingRepository> stagingRepositoryId = dto;
        return new StagingRepositoryDescriptor(this.baseUrl, (String)((Object)stagingRepositoryId));
    }

    public void closeStagingRepository(@NotNull String stagingRepositoryId, @NotNull String description) {
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response;
        Intrinsics.checkParameterIsNotNull(stagingRepositoryId, "stagingRepositoryId");
        Intrinsics.checkParameterIsNotNull(description, "description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response2 = response = this.api.closeStagingRepo(new Dto<StagingRepositoryToTransit>(new StagingRepositoryToTransit(CollectionsKt.listOf(stagingRepositoryId), description, false, 4, null))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("close staging repository", response);
        }
    }

    public void releaseStagingRepository(@NotNull String stagingRepositoryId, @NotNull String description) {
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response;
        Intrinsics.checkParameterIsNotNull(stagingRepositoryId, "stagingRepositoryId");
        Intrinsics.checkParameterIsNotNull(description, "description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response2 = response = this.api.releaseStagingRepo(new Dto<StagingRepositoryToTransit>(new StagingRepositoryToTransit(CollectionsKt.listOf(stagingRepositoryId), description, false, 4, null))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("release staging repository", response);
        }
    }

    @NotNull
    public StagingRepository getStagingRepositoryStateById(@NotNull String stagingRepositoryId) {
        Intrinsics.checkParameterIsNotNull(stagingRepositoryId, "stagingRepositoryId");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<ReadStagingRepository> response = this.api.getStagingRepoById(stagingRepositoryId).execute();
        if (response.code() == 404) {
            Object object = response.errorBody();
            if (object != null && (object = ((ResponseBody)object).string()) != null) {
                if (StringsKt.contains$default((CharSequence)object, stagingRepositoryId, false, 2, null)) {
                    return StagingRepository.Companion.notFound(stagingRepositoryId);
                }
            }
        }
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<ReadStagingRepository> response2 = response;
        Intrinsics.checkExpressionValueIsNotNull(response2, "response");
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("get staging repository by id", response);
        }
        ReadStagingRepository readStagingRepo = response.body();
        if (readStagingRepo != null) {
            boolean bl = Intrinsics.areEqual(stagingRepositoryId, readStagingRepo.getRepositoryId());
            if (!bl) {
                boolean bl2 = false;
                String string = "Unexpected read repository id (" + stagingRepositoryId + " != " + readStagingRepo.getRepositoryId() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return new StagingRepository(readStagingRepo.getRepositoryId(), StagingRepository.State.Companion.parseString(readStagingRepo.getType()), readStagingRepo.getTransitioning());
        }
        return StagingRepository.Companion.notFound(stagingRepositoryId);
    }

    /*
     * WARNING - void declaration
     */
    private final RuntimeException failure(String action, io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<?> response) {
        String message = "Failed to " + action + ", server at " + this.baseUrl + " responded with status code " + response.code();
        ResponseBody errorBody = response.errorBody();
        if (errorBody != null) {
            String string;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = new StringBuilder().append(message);
            try {
                stringBuilder = stringBuilder2;
                string = ", body: " + errorBody.string();
            }
            catch (IOException iOException) {
                void exception;
                stringBuilder = stringBuilder2;
                string = ", body: <error while reading body of error response, message: " + exception.getMessage() + '>';
            }
            message = stringBuilder.append(string).toString();
        }
        return new RuntimeException(message);
    }

    public NexusClient(@NotNull URI baseUrl, @Nullable String username, @Nullable String password, @Nullable Duration timeout, @Nullable Duration connectTimeout) {
        Intrinsics.checkParameterIsNotNull(baseUrl, "baseUrl");
        this.baseUrl = baseUrl;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (timeout != null) {
            httpClientBuilder.readTimeout(timeout).writeTimeout(timeout);
        }
        if (connectTimeout != null) {
            httpClientBuilder.connectTimeout(connectTimeout);
        }
        if (username != null || password != null) {
            String string;
            String string2 = username;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = password) == null) {
                string = "";
            }
            final String credentials = Credentials.basic(string2, string);
            httpClientBuilder.addInterceptor(new Interceptor(){

                @Override
                public final Response intercept(Interceptor.Chain chain) {
                    return chain.proceed(chain.request().newBuilder().header("Authorization", credentials).build());
                }
            });
        }
        httpClientBuilder.addInterceptor(new Interceptor(){

            @Override
            public final Response intercept(Interceptor.Chain chain) {
                Package package_ = this.getClass().getPackage();
                Intrinsics.checkExpressionValueIsNotNull(package_, "javaClass.`package`");
                String string = package_.getImplementationVersion();
                if (string == null) {
                    string = "dev";
                }
                String version = string;
                return chain.proceed(chain.request().newBuilder().header("User-Agent", "gradle-nexus-publish-plugin/" + version).build());
            }
        });
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl.toString()).client(httpClientBuilder.build()).addConverterFactory(GsonConverterFactory.create()).build();
        NexusApi nexusApi = retrofit.create(NexusApi.class);
        Intrinsics.checkExpressionValueIsNotNull(nexusApi, "retrofit.create(NexusApi::class.java)");
        this.api = nexusApi;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H'J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u0010H'J$\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\u00040\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u0010H'J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H'J.\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00040\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u00102\u000e\b\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004H'R&\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi;", "", "stagingProfiles", "Lio/github/gradlenexus/publishplugin/shadow/retrofit2/Call;", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingProfile;", "getStagingProfiles", "()Lretrofit2/Call;", "closeStagingRepo", "", "stagingRepoToClose", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingRepositoryToTransit;", "getStagingRepoById", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$ReadStagingRepository;", "stagingRepoId", "", "getStagingRepositories", "stagingProfileId", "releaseStagingRepo", "startStagingRepo", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$CreatedStagingRepository;", "description", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$Description;", "Companion", "publish-plugin"})
    private static interface NexusApi {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Headers(value={"Accept: application/json"})
        @GET(value="staging/profiles")
        @NotNull
        public Call<Dto<List<StagingProfile>>> getStagingProfiles();

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/profiles/{stagingProfileId}/start")
        @NotNull
        public Call<Dto<CreatedStagingRepository>> startStagingRepo(@Path(value="stagingProfileId") @NotNull String var1, @Body @NotNull Dto<Description> var2);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/bulk/close")
        @NotNull
        public Call<Unit> closeStagingRepo(@Body @NotNull Dto<StagingRepositoryToTransit> var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/bulk/promote")
        @NotNull
        public Call<Unit> releaseStagingRepo(@Body @NotNull Dto<StagingRepositoryToTransit> var1);

        @Headers(value={"Accept: application/json"})
        @GET(value="staging/repository/{stagingRepoId}")
        @NotNull
        public Call<ReadStagingRepository> getStagingRepoById(@Path(value="stagingRepoId") @NotNull String var1);

        @Headers(value={"Accept: application/json"})
        @GET(value="staging/profile_repositories/{stagingProfileId}")
        @NotNull
        public Call<Dto<List<ReadStagingRepository>>> getStagingRepositories(@Path(value="stagingProfileId") @NotNull String var1);

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi$Companion;", "", "()V", "RELEASE_OPERATION_NAME_IN_NEXUS", "", "publish-plugin"})
        public static final class Companion {
            private static final String RELEASE_OPERATION_NAME_IN_NEXUS = "promote";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "T", "", "data", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "setData", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "equals", "", "other", "hashCode", "", "toString", "", "publish-plugin"})
    public static final class Dto<T> {
        private T data;

        public final T getData() {
            return this.data;
        }

        public final void setData(T t) {
            this.data = t;
        }

        public Dto(T data) {
            this.data = data;
        }

        public final T component1() {
            return this.data;
        }

        @NotNull
        public final Dto<T> copy(T data) {
            return new Dto<T>(data);
        }

        public static /* synthetic */ Dto copy$default(Dto dto, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = dto.data;
            }
            return dto.copy(object);
        }

        @NotNull
        public String toString() {
            return "Dto(data=" + this.data + ")";
        }

        public int hashCode() {
            T t = this.data;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Dto)) break block3;
                    Dto dto = (Dto)object;
                    if (!Intrinsics.areEqual(this.data, dto.data)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingProfile;", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "getName", "setName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class StagingProfile {
        @NotNull
        private String id;
        @NotNull
        private String name;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final void setId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.id = string;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.name = string;
        }

        public StagingProfile(@NotNull String id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.id = id;
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final StagingProfile copy(@NotNull String id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(name, "name");
            return new StagingProfile(id, name);
        }

        public static /* synthetic */ StagingProfile copy$default(StagingProfile stagingProfile, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = stagingProfile.id;
            }
            if ((n & 2) != 0) {
                string2 = stagingProfile.name;
            }
            return stagingProfile.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "StagingProfile(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StagingProfile)) break block3;
                    StagingProfile stagingProfile = (StagingProfile)object;
                    if (!Intrinsics.areEqual(this.id, stagingProfile.id) || !Intrinsics.areEqual(this.name, stagingProfile.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$Description;", "", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class Description {
        @NotNull
        private final String description;

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public Description(@NotNull String description) {
            Intrinsics.checkParameterIsNotNull(description, "description");
            this.description = description;
        }

        @NotNull
        public final String component1() {
            return this.description;
        }

        @NotNull
        public final Description copy(@NotNull String description) {
            Intrinsics.checkParameterIsNotNull(description, "description");
            return new Description(description);
        }

        public static /* synthetic */ Description copy$default(Description description, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = description.description;
            }
            return description.copy(string);
        }

        @NotNull
        public String toString() {
            return "Description(description=" + this.description + ")";
        }

        public int hashCode() {
            String string = this.description;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Description)) break block3;
                    Description description = (Description)object;
                    if (!Intrinsics.areEqual(this.description, description.description)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$CreatedStagingRepository;", "", "stagedRepositoryId", "", "(Ljava/lang/String;)V", "getStagedRepositoryId", "()Ljava/lang/String;", "setStagedRepositoryId", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class CreatedStagingRepository {
        @NotNull
        private String stagedRepositoryId;

        @NotNull
        public final String getStagedRepositoryId() {
            return this.stagedRepositoryId;
        }

        public final void setStagedRepositoryId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.stagedRepositoryId = string;
        }

        public CreatedStagingRepository(@NotNull String stagedRepositoryId) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryId, "stagedRepositoryId");
            this.stagedRepositoryId = stagedRepositoryId;
        }

        @NotNull
        public final String component1() {
            return this.stagedRepositoryId;
        }

        @NotNull
        public final CreatedStagingRepository copy(@NotNull String stagedRepositoryId) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryId, "stagedRepositoryId");
            return new CreatedStagingRepository(stagedRepositoryId);
        }

        public static /* synthetic */ CreatedStagingRepository copy$default(CreatedStagingRepository createdStagingRepository, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = createdStagingRepository.stagedRepositoryId;
            }
            return createdStagingRepository.copy(string);
        }

        @NotNull
        public String toString() {
            return "CreatedStagingRepository(stagedRepositoryId=" + this.stagedRepositoryId + ")";
        }

        public int hashCode() {
            String string = this.stagedRepositoryId;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CreatedStagingRepository)) break block3;
                    CreatedStagingRepository createdStagingRepository = (CreatedStagingRepository)object;
                    if (!Intrinsics.areEqual(this.stagedRepositoryId, createdStagingRepository.stagedRepositoryId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\f\u00a8\u0006\u001f"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$ReadStagingRepository;", "", "repositoryId", "", "type", "transitioning", "", "description", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "getRepositoryId", "setRepositoryId", "getTransitioning", "()Z", "setTransitioning", "(Z)V", "getType", "setType", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class ReadStagingRepository {
        @NotNull
        private String repositoryId;
        @NotNull
        private String type;
        private boolean transitioning;
        @Nullable
        private String description;

        @NotNull
        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.repositoryId = string;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.type = string;
        }

        public final boolean getTransitioning() {
            return this.transitioning;
        }

        public final void setTransitioning(boolean bl) {
            this.transitioning = bl;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        public ReadStagingRepository(@NotNull String repositoryId, @NotNull String type, boolean transitioning, @Nullable String description) {
            Intrinsics.checkParameterIsNotNull(repositoryId, "repositoryId");
            Intrinsics.checkParameterIsNotNull(type, "type");
            this.repositoryId = repositoryId;
            this.type = type;
            this.transitioning = transitioning;
            this.description = description;
        }

        @NotNull
        public final String component1() {
            return this.repositoryId;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.transitioning;
        }

        @Nullable
        public final String component4() {
            return this.description;
        }

        @NotNull
        public final ReadStagingRepository copy(@NotNull String repositoryId, @NotNull String type, boolean transitioning, @Nullable String description) {
            Intrinsics.checkParameterIsNotNull(repositoryId, "repositoryId");
            Intrinsics.checkParameterIsNotNull(type, "type");
            return new ReadStagingRepository(repositoryId, type, transitioning, description);
        }

        public static /* synthetic */ ReadStagingRepository copy$default(ReadStagingRepository readStagingRepository, String string, String string2, boolean bl, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = readStagingRepository.repositoryId;
            }
            if ((n & 2) != 0) {
                string2 = readStagingRepository.type;
            }
            if ((n & 4) != 0) {
                bl = readStagingRepository.transitioning;
            }
            if ((n & 8) != 0) {
                string3 = readStagingRepository.description;
            }
            return readStagingRepository.copy(string, string2, bl, string3);
        }

        @NotNull
        public String toString() {
            return "ReadStagingRepository(repositoryId=" + this.repositoryId + ", type=" + this.type + ", transitioning=" + this.transitioning + ", description=" + this.description + ")";
        }

        public int hashCode() {
            String string = this.repositoryId;
            String string2 = this.type;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.transitioning ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string3 = this.description;
            return (n + n2) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReadStagingRepository)) break block3;
                    ReadStagingRepository readStagingRepository = (ReadStagingRepository)object;
                    if (!Intrinsics.areEqual(this.repositoryId, readStagingRepository.repositoryId) || !Intrinsics.areEqual(this.type, readStagingRepository.type) || this.transitioning != readStagingRepository.transitioning || !Intrinsics.areEqual(this.description, readStagingRepository.description)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingRepositoryToTransit;", "", "stagedRepositoryIds", "", "", "description", "autoDropAfterRelease", "", "(Ljava/util/List;Ljava/lang/String;Z)V", "getAutoDropAfterRelease", "()Z", "getDescription", "()Ljava/lang/String;", "getStagedRepositoryIds", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class StagingRepositoryToTransit {
        @NotNull
        private final List<String> stagedRepositoryIds;
        @NotNull
        private final String description;
        private final boolean autoDropAfterRelease;

        @NotNull
        public final List<String> getStagedRepositoryIds() {
            return this.stagedRepositoryIds;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final boolean getAutoDropAfterRelease() {
            return this.autoDropAfterRelease;
        }

        public StagingRepositoryToTransit(@NotNull List<String> stagedRepositoryIds, @NotNull String description, boolean autoDropAfterRelease) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryIds, "stagedRepositoryIds");
            Intrinsics.checkParameterIsNotNull(description, "description");
            this.stagedRepositoryIds = stagedRepositoryIds;
            this.description = description;
            this.autoDropAfterRelease = autoDropAfterRelease;
        }

        public /* synthetic */ StagingRepositoryToTransit(List list, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(list, string, bl);
        }

        @NotNull
        public final List<String> component1() {
            return this.stagedRepositoryIds;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        public final boolean component3() {
            return this.autoDropAfterRelease;
        }

        @NotNull
        public final StagingRepositoryToTransit copy(@NotNull List<String> stagedRepositoryIds, @NotNull String description, boolean autoDropAfterRelease) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryIds, "stagedRepositoryIds");
            Intrinsics.checkParameterIsNotNull(description, "description");
            return new StagingRepositoryToTransit(stagedRepositoryIds, description, autoDropAfterRelease);
        }

        public static /* synthetic */ StagingRepositoryToTransit copy$default(StagingRepositoryToTransit stagingRepositoryToTransit, List list, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = stagingRepositoryToTransit.stagedRepositoryIds;
            }
            if ((n & 2) != 0) {
                string = stagingRepositoryToTransit.description;
            }
            if ((n & 4) != 0) {
                bl = stagingRepositoryToTransit.autoDropAfterRelease;
            }
            return stagingRepositoryToTransit.copy(list, string, bl);
        }

        @NotNull
        public String toString() {
            return "StagingRepositoryToTransit(stagedRepositoryIds=" + this.stagedRepositoryIds + ", description=" + this.description + ", autoDropAfterRelease=" + this.autoDropAfterRelease + ")";
        }

        public int hashCode() {
            List<String> list = this.stagedRepositoryIds;
            String string = this.description;
            int n = ((list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.autoDropAfterRelease ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StagingRepositoryToTransit)) break block3;
                    StagingRepositoryToTransit stagingRepositoryToTransit = (StagingRepositoryToTransit)object;
                    if (!Intrinsics.areEqual(this.stagedRepositoryIds, stagingRepositoryToTransit.stagedRepositoryIds) || !Intrinsics.areEqual(this.description, stagingRepositoryToTransit.description) || this.autoDropAfterRelease != stagingRepositoryToTransit.autoDropAfterRelease) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

