/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpBuilder;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.HttpObjectConfig;
import groovyx.net.http.ProxyInfo;
import groovyx.net.http.ToServer;
import groovyx.net.http.util.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpBuilder
extends HttpBuilder {
    private static final Function<HttpObjectConfig, ? extends HttpBuilder> apacheFactory = ApacheHttpBuilder::new;
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpBuilder.class);
    private final CloseableHttpClient client;
    private final ChainedHttpConfig config;
    private final Executor executor;
    private final HttpObjectConfig.Client clientConfig;
    private final ProxyInfo proxyInfo;

    public static HttpBuilder configure(@DelegatesTo(value=HttpObjectConfig.class) Closure closure) {
        return ApacheHttpBuilder.configure(apacheFactory, (Closure)closure);
    }

    public static HttpBuilder configure(Consumer<HttpObjectConfig> configuration) {
        return ApacheHttpBuilder.configure(apacheFactory, configuration);
    }

    private SSLContext sslContext(HttpObjectConfig config) {
        try {
            return config.getExecution().getSslContext() != null ? config.getExecution().getSslContext() : SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private Registry<ConnectionSocketFactory> registry(HttpObjectConfig config) {
        boolean isSocksProxied;
        ProxyInfo proxyInfo = config.getExecution().getProxyInfo();
        boolean bl = isSocksProxied = proxyInfo != null && proxyInfo.getProxy().type() == Proxy.Type.SOCKS;
        if (isSocksProxied) {
            return RegistryBuilder.create().register("http", (Object)new SocksHttp(proxyInfo.getProxy())).register("https", (Object)new SocksHttps(proxyInfo.getProxy(), this.sslContext(config), config.getExecution().getHostnameVerifier())).build();
        }
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(this.sslContext(config), config.getExecution().getHostnameVerifier())).build();
    }

    public ApacheHttpBuilder(HttpObjectConfig config) {
        super(config);
        PoolingHttpClientConnectionManager cm;
        this.proxyInfo = config.getExecution().getProxyInfo();
        this.config = new HttpConfigs.ThreadSafeHttpConfig(config.getChainedConfig());
        this.executor = config.getExecution().getExecutor();
        this.clientConfig = config.getClient();
        HttpClientBuilder myBuilder = HttpClients.custom();
        Registry<ConnectionSocketFactory> registry = this.registry(config);
        if (config.getExecution().getMaxThreads() > 1) {
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(config.getExecution().getMaxThreads());
            cm.setDefaultMaxPerRoute(config.getExecution().getMaxThreads());
            myBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        } else {
            cm = new BasicHttpClientConnectionManager(registry);
            myBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        SSLContext sslContext = config.getExecution().getSslContext();
        if (sslContext != null) {
            myBuilder.setSSLContext(sslContext);
            myBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, config.getExecution().getHostnameVerifier()));
        }
        myBuilder.addInterceptorFirst((response, context) -> {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement codec : codecs = ceheader.getElements()) {
                    if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        });
        Consumer clientCustomizer = this.clientConfig.getClientCustomizer();
        if (clientCustomizer != null) {
            clientCustomizer.accept(myBuilder);
        }
        this.client = myBuilder.build();
    }

    public Object getClientImplementation() {
        return this.client;
    }

    protected ChainedHttpConfig getObjectConfig() {
        return this.config;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void close() {
        block2: {
            try {
                this.client.close();
            }
            catch (IOException ioe) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Error in closing http client", (Throwable)ioe);
            }
        }
    }

    private void basicAuth(HttpClientContext c, HttpConfig.Auth auth, URI uri) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(auth.getUser(), auth.getPassword()));
        c.setCredentialsProvider((CredentialsProvider)provider);
    }

    private void digestAuth(HttpClientContext c, HttpConfig.Auth auth, URI uri) {
        this.basicAuth(c, auth, uri);
    }

    private HttpClientContext context(ChainedHttpConfig requestConfig) throws URISyntaxException {
        HttpClientContext c = HttpClientContext.create();
        ChainedHttpConfig.ChainedRequest cr = requestConfig.getChainedRequest();
        HttpConfig.Auth auth = cr.actualAuth();
        if (auth != null) {
            URI uri = requestConfig.getRequest().getUri().toURI();
            if (auth.getAuthType() == HttpConfig.AuthType.BASIC) {
                this.basicAuth(c, auth, uri);
            } else if (auth.getAuthType() == HttpConfig.AuthType.DIGEST) {
                this.digestAuth(c, auth, uri);
            }
        }
        return c;
    }

    private <T extends HttpRequestBase> Object exec(ChainedHttpConfig requestConfig, Function<URI, T> constructor) {
        try {
            ChainedHttpConfig.ChainedRequest cr = requestConfig.getChainedRequest();
            URI theUri = cr.getUri().toURI();
            HttpRequestBase request = (HttpRequestBase)constructor.apply(theUri);
            if (request instanceof HttpEntityEnclosingRequest && cr.actualBody() != null) {
                HttpEntity entity = this.entity(requestConfig);
                ((HttpEntityEnclosingRequest)request).setEntity(entity);
                request.setHeader(entity.getContentType());
            }
            this.addHeaders(cr, request);
            if (this.proxyInfo != null && this.proxyInfo.getProxy().type() == Proxy.Type.HTTP) {
                HttpHost proxy = new HttpHost(this.proxyInfo.getAddress(), this.proxyInfo.getPort(), this.proxyInfo.isSecure() ? "https" : "http");
                request.setConfig(RequestConfig.custom().setProxy(proxy).build());
            }
            return this.client.execute((HttpUriRequest)request, (ResponseHandler)new Handler(requestConfig), (HttpContext)this.context(requestConfig));
        }
        catch (Exception e) {
            return this.handleException(requestConfig.getChainedResponse(), e);
        }
    }

    private HttpEntity entity(ChainedHttpConfig config) {
        ApacheToServer ats = new ApacheToServer(config);
        config.findEncoder().accept(config, ats);
        return ats;
    }

    private <T extends HttpUriRequest> void addHeaders(ChainedHttpConfig.ChainedRequest cr, T message) throws URISyntaxException {
        for (Map.Entry entry : cr.actualHeaders(new LinkedHashMap()).entrySet()) {
            message.addHeader((String)entry.getKey(), entry.getValue() != null ? ((CharSequence)entry.getValue()).toString() : null);
        }
        String contentType = cr.actualContentType();
        if (contentType != null) {
            Charset charset = cr.actualCharset();
            if (charset != null) {
                message.setHeader("Content-Type", contentType + "; charset=" + charset.toString().toLowerCase());
            } else {
                message.setHeader("Content-Type", contentType);
            }
        }
        for (Map.Entry e : this.cookiesToAdd(this.clientConfig, cr).entrySet()) {
            message.addHeader((String)e.getKey(), (String)e.getValue());
        }
    }

    protected Object doGet(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpGet::new);
    }

    protected Object doHead(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpHead::new);
    }

    protected Object doPost(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpPost::new);
    }

    protected Object doPut(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpPut::new);
    }

    protected Object doPatch(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpPatch::new);
    }

    protected Object doDelete(ChainedHttpConfig requestConfig) {
        return this.exec(requestConfig, HttpDelete::new);
    }

    protected Object doOptions(ChainedHttpConfig config) {
        return this.exec(config, HttpOptions::new);
    }

    protected Object doTrace(ChainedHttpConfig config) {
        return this.exec(config, HttpTrace::new);
    }

    private class Handler
    implements ResponseHandler<Object> {
        private final ChainedHttpConfig requestConfig;
        private final URI theUri;

        public Handler(ChainedHttpConfig requestConfig) throws URISyntaxException {
            this.requestConfig = requestConfig;
            this.theUri = requestConfig.getChainedRequest().getUri().toURI();
        }

        public Object handleResponse(HttpResponse response) {
            return HttpBuilder.ResponseHandlerFunction.HANDLER_FUNCTION.apply(this.requestConfig, (FromServer)new ApacheFromServer(this.theUri, response));
        }
    }

    public static class ApacheToServer
    implements ToServer,
    HttpEntity {
        private ChainedHttpConfig config;
        private byte[] bytes;

        public ApacheToServer(ChainedHttpConfig config) {
            this.config = config;
        }

        public void toServer(InputStream inputStream) {
            try {
                this.bytes = IoUtils.streamToBytes((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isChunked() {
            return false;
        }

        public long getContentLength() {
            return this.bytes.length;
        }

        public Header getContentType() {
            return new BasicHeader("Content-Type", this.config.findContentType());
        }

        public Header getContentEncoding() {
            return null;
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.bytes);
        }

        public void writeTo(OutputStream outputStream) {
            IoUtils.transfer((InputStream)this.getContent(), (OutputStream)outputStream, (boolean)false);
        }

        public boolean isStreaming() {
            return true;
        }

        public void consumeContent() throws IOException {
            this.bytes = null;
        }
    }

    private class ApacheFromServer
    implements FromServer {
        private final HttpResponse response;
        private final HttpEntity entity;
        private final List<FromServer.Header<?>> headers;
        private final InputStream inputStream;
        private final URI uri;

        public ApacheFromServer(URI originalUri, HttpResponse response) {
            this.uri = originalUri;
            this.response = response;
            this.entity = response.getEntity();
            if (this.entity != null) {
                try {
                    this.inputStream = this.entity.getContent();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get input stream from apache http client", e);
                }
            } else {
                this.inputStream = null;
            }
            this.headers = new ArrayList(response.getAllHeaders().length);
            for (Header header : response.getAllHeaders()) {
                this.headers.add(FromServer.Header.keyValue((String)header.getName(), (String)header.getValue()));
            }
            ApacheHttpBuilder.this.addCookieStore(this.uri, this.headers);
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public boolean getHasBody() {
            return this.entity != null && !(this.inputStream instanceof EmptyInputStream);
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getMessage() {
            return this.response.getStatusLine().getReasonPhrase();
        }

        public List<FromServer.Header<?>> getHeaders() {
            return this.headers;
        }

        public URI getUri() {
            return this.uri;
        }

        public void finish() {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
    }

    private class SocksHttps
    extends SSLConnectionSocketFactory {
        final Proxy proxy;

        public SocksHttps(Proxy proxy, SSLContext sslContext, HostnameVerifier verifier) {
            super(sslContext, verifier);
            this.proxy = proxy;
        }

        public Socket createSocket(HttpContext context) {
            return new Socket(this.proxy);
        }
    }

    private class SocksHttp
    extends PlainConnectionSocketFactory {
        final Proxy proxy;

        public SocksHttp(Proxy proxy) {
            this.proxy = proxy;
        }

        public Socket createSocket(HttpContext context) {
            return new Socket(this.proxy);
        }
    }
}

