/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.datasource;

import android.net.Uri;
import com.sangcomz.fishbun.Fishton;
import com.sangcomz.fishbun.MimeType;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.FishBunDataSource;
import com.sangcomz.fishbun.ui.album.model.AlbumMenuViewData;
import com.sangcomz.fishbun.ui.album.model.AlbumViewData;
import com.sangcomz.fishbun.ui.detail.model.DetailImageViewData;
import com.sangcomz.fishbun.ui.picker.model.PickerMenuViewData;
import com.sangcomz.fishbun.ui.picker.model.PickerViewData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0016\u0010&\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0016J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/sangcomz/fishbun/datasource/FishBunDataSourceImpl;", "Lcom/sangcomz/fishbun/datasource/FishBunDataSource;", "fishton", "Lcom/sangcomz/fishbun/Fishton;", "(Lcom/sangcomz/fishbun/Fishton;)V", "gatAlbumMenuViewData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumMenuViewData;", "getAlbumViewData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumViewData;", "getAllViewTitle", "", "getDetailViewData", "Lcom/sangcomz/fishbun/ui/detail/model/DetailImageViewData;", "getExceptMimeTypeList", "", "Lcom/sangcomz/fishbun/MimeType;", "getImageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "getIsAutomaticClose", "", "getMaxCount", "", "getMessageLimitReached", "getMessageNothingSelected", "getMinCount", "getPickerImages", "Landroid/net/Uri;", "getPickerMenuViewData", "Lcom/sangcomz/fishbun/ui/picker/model/PickerMenuViewData;", "getPickerViewData", "Lcom/sangcomz/fishbun/ui/picker/model/PickerViewData;", "getSelectedImageList", "getSpecifyFolderList", "hasCameraInPickerPage", "isStartInAllView", "selectImage", "", "imageUri", "setCurrentPickerImageList", "pickerImageList", "unselectImage", "useDetailView", "fishbun_release"})
public final class FishBunDataSourceImpl
implements FishBunDataSource {
    @NotNull
    private final Fishton fishton;

    public FishBunDataSourceImpl(@NotNull Fishton fishton) {
        Intrinsics.checkNotNullParameter((Object)fishton, (String)"fishton");
        this.fishton = fishton;
    }

    @Override
    @NotNull
    public List<Uri> getSelectedImageList() {
        return this.fishton.getSelectedImages();
    }

    @Override
    @NotNull
    public List<Uri> getPickerImages() {
        return this.fishton.getCurrentPickerImageList();
    }

    @Override
    public int getMaxCount() {
        return this.fishton.getMaxCount();
    }

    @Override
    public int getMinCount() {
        return this.fishton.getMinCount();
    }

    @Override
    public boolean getIsAutomaticClose() {
        return this.fishton.isAutomaticClose();
    }

    @Override
    @NotNull
    public String getMessageLimitReached() {
        return this.fishton.getMessageLimitReached();
    }

    @Override
    @NotNull
    public String getMessageNothingSelected() {
        return this.fishton.getMessageNothingSelected();
    }

    @Override
    @NotNull
    public List<MimeType> getExceptMimeTypeList() {
        return this.fishton.getExceptMimeTypeList();
    }

    @Override
    @NotNull
    public List<String> getSpecifyFolderList() {
        return this.fishton.getSpecifyFolderList();
    }

    @Override
    @NotNull
    public String getAllViewTitle() {
        return this.fishton.getTitleAlbumAllView();
    }

    @Override
    @NotNull
    public ImageAdapter getImageAdapter() {
        return this.fishton.getImageAdapter();
    }

    @Override
    public void selectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishton.getSelectedImages().add(imageUri);
    }

    @Override
    public void unselectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishton.getSelectedImages().remove(imageUri);
    }

    @Override
    @NotNull
    public DetailImageViewData getDetailViewData() {
        return new DetailImageViewData(this.fishton.getColorStatusBar(), this.fishton.isStatusBarLight(), this.fishton.getColorActionBar(), this.fishton.getColorActionBarTitle(), this.fishton.getColorSelectCircleStroke());
    }

    @Override
    @NotNull
    public AlbumViewData getAlbumViewData() {
        return new AlbumViewData(this.fishton.getColorStatusBar(), this.fishton.isStatusBarLight(), this.fishton.getColorActionBar(), this.fishton.getColorActionBarTitle(), this.fishton.getTitleActionBar(), this.fishton.getDrawableHomeAsUpIndicator(), this.fishton.getAlbumPortraitSpanCount(), this.fishton.getAlbumLandscapeSpanCount(), this.fishton.getAlbumThumbnailSize(), this.fishton.getMaxCount(), this.fishton.isShowCount());
    }

    @Override
    @NotNull
    public AlbumMenuViewData gatAlbumMenuViewData() {
        return new AlbumMenuViewData(this.fishton.getHasButtonInAlbumActivity(), this.fishton.getDrawableDoneButton(), this.fishton.getStrDoneMenu(), this.fishton.getColorTextMenu());
    }

    @Override
    @NotNull
    public PickerViewData getPickerViewData() {
        return new PickerViewData(this.fishton.getColorStatusBar(), this.fishton.isStatusBarLight(), this.fishton.getColorActionBar(), this.fishton.getColorActionBarTitle(), this.fishton.getTitleActionBar(), this.fishton.getDrawableHomeAsUpIndicator(), this.fishton.getAlbumPortraitSpanCount(), this.fishton.getAlbumLandscapeSpanCount(), this.fishton.getAlbumThumbnailSize(), this.fishton.getMaxCount(), this.fishton.isShowCount(), this.fishton.getColorSelectCircleStroke(), this.fishton.isAutomaticClose(), this.fishton.getPhotoSpanCount());
    }

    @Override
    public void setCurrentPickerImageList(@NotNull List<? extends Uri> pickerImageList) {
        Intrinsics.checkNotNullParameter(pickerImageList, (String)"pickerImageList");
        this.fishton.setCurrentPickerImageList(pickerImageList);
    }

    @Override
    public boolean hasCameraInPickerPage() {
        return this.fishton.getHasCameraInPickerPage();
    }

    @Override
    public boolean useDetailView() {
        return this.fishton.isUseDetailView();
    }

    @Override
    @NotNull
    public PickerMenuViewData getPickerMenuViewData() {
        return new PickerMenuViewData(this.fishton.getDrawableDoneButton(), this.fishton.getDrawableAllDoneButton(), this.fishton.getStrDoneMenu(), this.fishton.getColorTextMenu(), this.fishton.getStrAllDoneMenu(), this.fishton.isUseAllDoneButton());
    }

    @Override
    public boolean isStartInAllView() {
        return this.fishton.isStartInAllView();
    }
}

