/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.ui.album.listener.AlbumClickListener;
import com.sangcomz.fishbun.ui.album.model.Album;
import com.sangcomz.fishbun.ui.album.model.AlbumMetaData;
import com.sangcomz.fishbun.util.SquareImageView;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sangcomz/fishbun/ui/album/adapter/AlbumListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/sangcomz/fishbun/ui/album/adapter/AlbumListAdapter$ViewHolder;", "albumClickListener", "Lcom/sangcomz/fishbun/ui/album/listener/AlbumClickListener;", "thumbnailSize", "", "imageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "(Lcom/sangcomz/fishbun/ui/album/listener/AlbumClickListener;ILcom/sangcomz/fishbun/adapter/image/ImageAdapter;)V", "albumList", "", "Lcom/sangcomz/fishbun/ui/album/model/Album;", "getItemCount", "getItemId", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setAlbumList", "updateAlbumMeta", "addedCount", "thumbnailPath", "", "ViewHolder", "fishbun_release"})
public final class AlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private final AlbumClickListener albumClickListener;
    private final int thumbnailSize;
    @Nullable
    private final ImageAdapter imageAdapter;
    @NotNull
    private List<Album> albumList;

    public AlbumListAdapter(@NotNull AlbumClickListener albumClickListener, int thumbnailSize, @Nullable ImageAdapter imageAdapter) {
        Intrinsics.checkNotNullParameter((Object)albumClickListener, (String)"albumClickListener");
        this.albumClickListener = albumClickListener;
        this.thumbnailSize = thumbnailSize;
        this.imageAdapter = imageAdapter;
        this.albumList = CollectionsKt.emptyList();
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.albumList.get(position).getId();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ViewHolder viewHolder = new ViewHolder(parent, this.thumbnailSize, this.imageAdapter);
        boolean bl = false;
        boolean bl2 = false;
        ViewHolder $this$onCreateViewHolder_u24lambda_u2d1 = viewHolder;
        boolean bl3 = false;
        $this$onCreateViewHolder_u24lambda_u2d1.itemView.setOnClickListener(arg_0 -> AlbumListAdapter.onCreateViewHolder$lambda-1$lambda-0(this, $this$onCreateViewHolder_u24lambda_u2d1, arg_0));
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.setData(this.albumList.get(position));
    }

    public final void setAlbumList(@NotNull List<Album> albumList) {
        Intrinsics.checkNotNullParameter(albumList, (String)"albumList");
        this.albumList = albumList;
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAlbumMeta(int position, int addedCount, @NotNull String thumbnailPath) {
        void $this$updateAlbumMeta_u24lambda_u2d2;
        Intrinsics.checkNotNullParameter((Object)thumbnailPath, (String)"thumbnailPath");
        Album oldAlbum = this.albumList.get(position);
        Album updateAlbum = Album.copy$default(oldAlbum, 0L, null, new AlbumMetaData(oldAlbum.getMetaData().getCount() + addedCount, thumbnailPath), 3, null);
        List list = CollectionsKt.toMutableList((Collection)this.albumList);
        boolean bl = false;
        boolean bl2 = false;
        List list2 = list;
        AlbumListAdapter albumListAdapter = this;
        boolean bl3 = false;
        $this$updateAlbumMeta_u24lambda_u2d2.set(position, updateAlbum);
        Unit unit = Unit.INSTANCE;
        albumListAdapter.albumList = list;
        this.notifyItemChanged(position);
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    private static final void onCreateViewHolder$lambda-1$lambda-0(AlbumListAdapter this$0, ViewHolder $this_apply, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_apply), (String)"$this_apply");
        this$0.albumClickListener.onAlbumClick($this_apply.getAdapterPosition(), this$0.albumList.get($this_apply.getAdapterPosition()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sangcomz/fishbun/ui/album/adapter/AlbumListAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "albumSize", "", "imageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "(Landroid/view/ViewGroup;ILcom/sangcomz/fishbun/adapter/image/ImageAdapter;)V", "imgAlbumThumb", "Lcom/sangcomz/fishbun/util/SquareImageView;", "txtAlbumCount", "Landroid/widget/TextView;", "txtAlbumName", "setData", "", "album", "Lcom/sangcomz/fishbun/ui/album/model/Album;", "fishbun_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        private final ImageAdapter imageAdapter;
        @NotNull
        private final SquareImageView imgAlbumThumb;
        @NotNull
        private final TextView txtAlbumName;
        @NotNull
        private final TextView txtAlbumCount;

        public ViewHolder(@NotNull ViewGroup parent, int albumSize, @Nullable ImageAdapter imageAdapter) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item, parent, false));
            this.imageAdapter = imageAdapter;
            View view = this.itemView.findViewById(R.id.img_album_thumb);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.img_album_thumb)");
            this.imgAlbumThumb = (SquareImageView)view;
            view = this.itemView.findViewById(R.id.txt_album_name);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.txt_album_name)");
            this.txtAlbumName = (TextView)view;
            view = this.itemView.findViewById(R.id.txt_album_count);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.txt_album_count)");
            this.txtAlbumCount = (TextView)view;
            this.imgAlbumThumb.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(albumSize, albumSize));
        }

        public final void setData(@NotNull Album album) {
            Intrinsics.checkNotNullParameter((Object)album, (String)"album");
            Object object = Uri.parse((String)album.getMetaData().getThumbnailPath());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(album.metaData.thumbnailPath)");
            Uri uri = object;
            object = this.imageAdapter;
            if (object != null) {
                object.loadImage((ImageView)this.imgAlbumThumb, uri);
            }
            this.itemView.setTag((Object)album);
            this.txtAlbumName.setText((CharSequence)album.getDisplayName());
            this.txtAlbumCount.setText((CharSequence)String.valueOf(album.getMetaData().getCount()));
        }
    }
}

