/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album.mvp;

import android.net.Uri;
import com.sangcomz.fishbun.ui.album.AlbumContract;
import com.sangcomz.fishbun.ui.album.model.Album;
import com.sangcomz.fishbun.ui.album.model.AlbumMenuViewData;
import com.sangcomz.fishbun.ui.album.model.AlbumViewData;
import com.sangcomz.fishbun.ui.album.model.repository.AlbumRepository;
import com.sangcomz.fishbun.util.UiHandler;
import com.sangcomz.fishbun.util.future.CallableFutureTask;
import com.sangcomz.fishbun.util.future.FutureCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016R\u001c\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/sangcomz/fishbun/ui/album/mvp/AlbumPresenter;", "Lcom/sangcomz/fishbun/ui/album/AlbumContract$Presenter;", "albumView", "Lcom/sangcomz/fishbun/ui/album/AlbumContract$View;", "albumRepository", "Lcom/sangcomz/fishbun/ui/album/model/repository/AlbumRepository;", "uiHandler", "Lcom/sangcomz/fishbun/util/UiHandler;", "(Lcom/sangcomz/fishbun/ui/album/AlbumContract$View;Lcom/sangcomz/fishbun/ui/album/model/repository/AlbumRepository;Lcom/sangcomz/fishbun/util/UiHandler;)V", "albumListFuture", "Lcom/sangcomz/fishbun/util/future/CallableFutureTask;", "", "Lcom/sangcomz/fishbun/ui/album/model/Album;", "changeToolbarTitle", "", "finish", "getAlbumMenuViewData", "callback", "Lkotlin/Function1;", "Lcom/sangcomz/fishbun/ui/album/model/AlbumMenuViewData;", "getDesignViewData", "getPathDir", "", "loadAlbumList", "onClickMenuDone", "onResume", "onSuccessTakePicture", "refreshAlbumItem", "position", "", "addedPathList", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "release", "takePicture", "Companion", "fishbun_release"})
public final class AlbumPresenter
implements AlbumContract.Presenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlbumContract.View albumView;
    @NotNull
    private final AlbumRepository albumRepository;
    @NotNull
    private final UiHandler uiHandler;
    @Nullable
    private CallableFutureTask<List<Album>> albumListFuture;
    @NotNull
    private static final String defaultDir = "/Camera";

    public AlbumPresenter(@NotNull AlbumContract.View albumView, @NotNull AlbumRepository albumRepository, @NotNull UiHandler uiHandler) {
        Intrinsics.checkNotNullParameter((Object)albumView, (String)"albumView");
        Intrinsics.checkNotNullParameter((Object)albumRepository, (String)"albumRepository");
        Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
        this.albumView = albumView;
        this.albumRepository = albumRepository;
        this.uiHandler = uiHandler;
    }

    @Override
    public void loadAlbumList() {
        this.albumListFuture = this.albumRepository.getAlbumList();
        CallableFutureTask<List<Album>> callableFutureTask = this.albumListFuture;
        if (callableFutureTask != null) {
            CallableFutureTask<List<Album>> callableFutureTask2 = callableFutureTask;
            boolean bl = false;
            boolean bl2 = false;
            CallableFutureTask<List<Album>> it = callableFutureTask2;
            boolean bl3 = false;
            it.execute((FutureCallback<List<Album>>)new FutureCallback<List<? extends Album>>(this, it){
                final /* synthetic */ AlbumPresenter this$0;
                final /* synthetic */ CallableFutureTask<List<Album>> $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                }

                public void onSuccess(@NotNull List<Album> result) {
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    AlbumPresenter.access$getUiHandler$p(this.this$0).run((Function0<Unit>)((Function0)new Function0<Unit>(result, this.this$0, this.$it){
                        final /* synthetic */ List<Album> $result;
                        final /* synthetic */ AlbumPresenter this$0;
                        final /* synthetic */ CallableFutureTask<List<Album>> $it;
                        {
                            this.$result = $result;
                            this.this$0 = $receiver;
                            this.$it = $it;
                            super(0);
                        }

                        public final void invoke() {
                            Collection<Object> collection = this.$result;
                            boolean bl = false;
                            if (!collection.isEmpty()) {
                                AlbumPresenter.access$changeToolbarTitle(this.this$0);
                                AlbumContract.View view = AlbumPresenter.access$getAlbumView$p(this.this$0);
                                collection = this.$it.get();
                                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.get()");
                                view.showAlbumList((List)collection, AlbumPresenter.access$getAlbumRepository$p(this.this$0).getImageAdapter(), AlbumPresenter.access$getAlbumRepository$p(this.this$0).getAlbumViewData());
                            } else {
                                AlbumPresenter.access$getAlbumView$p(this.this$0).showEmptyView();
                            }
                        }
                    }));
                }
            });
        }
    }

    @Override
    public void takePicture() {
        String string2 = this.albumRepository.getDefaultSavePath();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.albumView.takePicture(it);
        }
    }

    @Override
    public void getDesignViewData() {
        AlbumViewData viewData = this.albumRepository.getAlbumViewData();
        AlbumContract.View view = this.albumView;
        boolean bl = false;
        boolean bl2 = false;
        AlbumContract.View $this$getDesignViewData_u24lambda_u2d2 = view;
        boolean bl3 = false;
        $this$getDesignViewData_u24lambda_u2d2.setRecyclerView(viewData);
        $this$getDesignViewData_u24lambda_u2d2.setToolBar(viewData);
        this.changeToolbarTitle();
    }

    @Override
    public void onResume() {
        this.albumView.setRecyclerViewSpanCount(this.albumRepository.getAlbumViewData());
    }

    @Override
    public void finish() {
        this.albumView.finishActivityWithResult(this.albumRepository.getSelectedImageList());
    }

    @Override
    public void refreshAlbumItem(int position, @NotNull ArrayList<Uri> addedPathList) {
        Intrinsics.checkNotNullParameter(addedPathList, (String)"addedPathList");
        this.changeToolbarTitle();
        if (addedPathList.size() > 0) {
            if (position == 0) {
                this.loadAlbumList();
            } else {
                this.albumView.refreshAlbumItem(position, addedPathList);
            }
        }
    }

    @Override
    @Nullable
    public String getPathDir() {
        return this.albumRepository.getDefaultSavePath();
    }

    @Override
    public void release() {
        CallableFutureTask<List<Album>> callableFutureTask = this.albumListFuture;
        if (callableFutureTask != null) {
            callableFutureTask.cancel(true);
        }
    }

    private final void changeToolbarTitle() {
        this.albumView.changeToolbarTitle(this.albumRepository.getSelectedImageList().size(), this.albumRepository.getAlbumViewData());
    }

    @Override
    public void getAlbumMenuViewData(@NotNull Function1<? super AlbumMenuViewData, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        callback.invoke((Object)this.albumRepository.getAlbumMenuViewData());
    }

    @Override
    public void onClickMenuDone() {
        int selectedCount = this.albumRepository.getSelectedImageList().size();
        if (selectedCount == 0) {
            this.albumView.showNothingSelectedMessage(this.albumRepository.getMessageNotingSelected());
        } else if (selectedCount < this.albumRepository.getMinCount()) {
            this.albumView.showMinimumImageMessage(this.albumRepository.getMinCount());
        } else {
            this.finish();
        }
    }

    @Override
    public void onSuccessTakePicture() {
        this.albumView.saveImageForAndroidQOrHigher();
        this.albumView.scanAndRefresh();
    }

    public static final /* synthetic */ UiHandler access$getUiHandler$p(AlbumPresenter $this) {
        return $this.uiHandler;
    }

    public static final /* synthetic */ void access$changeToolbarTitle(AlbumPresenter $this) {
        $this.changeToolbarTitle();
    }

    public static final /* synthetic */ AlbumContract.View access$getAlbumView$p(AlbumPresenter $this) {
        return $this.albumView;
    }

    public static final /* synthetic */ AlbumRepository access$getAlbumRepository$p(AlbumPresenter $this) {
        return $this.albumRepository;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/sangcomz/fishbun/ui/album/mvp/AlbumPresenter$Companion;", "", "()V", "defaultDir", "", "fishbun_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

