/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album.ui;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.constraintlayout.widget.Group;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.BaseActivity;
import com.sangcomz.fishbun.Fishton;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.CameraDataSourceImpl;
import com.sangcomz.fishbun.datasource.FishBunDataSourceImpl;
import com.sangcomz.fishbun.datasource.ImageDataSourceImpl;
import com.sangcomz.fishbun.ui.album.AlbumContract;
import com.sangcomz.fishbun.ui.album.adapter.AlbumListAdapter;
import com.sangcomz.fishbun.ui.album.listener.AlbumClickListener;
import com.sangcomz.fishbun.ui.album.model.Album;
import com.sangcomz.fishbun.ui.album.model.AlbumMenuViewData;
import com.sangcomz.fishbun.ui.album.model.AlbumViewData;
import com.sangcomz.fishbun.ui.album.model.repository.AlbumRepositoryImpl;
import com.sangcomz.fishbun.ui.album.mvp.AlbumPresenter;
import com.sangcomz.fishbun.ui.picker.PickerActivity;
import com.sangcomz.fishbun.util.CameraUtil;
import com.sangcomz.fishbun.util.MainUiHandler;
import com.sangcomz.fishbun.util.SingleMediaScanner;
import com.sangcomz.fishbun.util.UiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0016\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010 \u001a\u00020\u0014H\u0002J\"\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0014H\u0014J\u0010\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u000203H\u0016J+\u00104\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00162\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000209H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\u0014H\u0014J(\u0010<\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00162\u0016\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u001f0>j\b\u0012\u0004\u0012\u00020\u001f`?H\u0016J\b\u0010@\u001a\u00020\u0014H\u0016J\b\u0010A\u001a\u00020\u0014H\u0016J&\u0010B\u001a\u00020\u00142\f\u0010C\u001a\b\u0012\u0004\u0012\u00020)0\u001e2\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010G\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010I\u001a\u00020\u00142\f\u0010C\u001a\b\u0012\u0004\u0012\u00020)0\u001e2\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010J\u001a\u00020\u0014H\u0016J\u0010\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020\u0016H\u0016J\u0010\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u000207H\u0016J\u0010\u0010O\u001a\u00020\u00142\u0006\u0010P\u001a\u000207H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/sangcomz/fishbun/ui/album/ui/AlbumActivity;", "Lcom/sangcomz/fishbun/BaseActivity;", "Lcom/sangcomz/fishbun/ui/album/AlbumContract$View;", "Lcom/sangcomz/fishbun/ui/album/listener/AlbumClickListener;", "()V", "adapter", "Lcom/sangcomz/fishbun/ui/album/adapter/AlbumListAdapter;", "albumPresenter", "Lcom/sangcomz/fishbun/ui/album/AlbumContract$Presenter;", "getAlbumPresenter", "()Lcom/sangcomz/fishbun/ui/album/AlbumContract$Presenter;", "albumPresenter$delegate", "Lkotlin/Lazy;", "groupEmptyView", "Landroidx/constraintlayout/widget/Group;", "recyclerAlbumList", "Landroidx/recyclerview/widget/RecyclerView;", "txtAlbumMessage", "Landroid/widget/TextView;", "changeToolbarTitle", "", "selectedImageCount", "", "albumViewData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumViewData;", "checkCameraPermission", "", "checkPermission", "finishActivityWithResult", "selectedImages", "", "Landroid/net/Uri;", "initView", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onAlbumClick", "position", "album", "Lcom/sangcomz/fishbun/ui/album/model/Album;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "refreshAlbumItem", "imagePath", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "saveImageForAndroidQOrHigher", "scanAndRefresh", "setAlbumListAdapter", "albumList", "imageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "setRecyclerView", "setRecyclerViewSpanCount", "setToolBar", "showAlbumList", "showEmptyView", "showMinimumImageMessage", "currentSelectedCount", "showNothingSelectedMessage", "nothingSelectedMessage", "takePicture", "saveDir", "fishbun_release"})
public final class AlbumActivity
extends BaseActivity
implements AlbumContract.View,
AlbumClickListener {
    @NotNull
    private final Lazy albumPresenter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AlbumPresenter>(this){
        final /* synthetic */ AlbumActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final AlbumPresenter invoke() {
            AlbumContract.View view = this.this$0;
            ContentResolver contentResolver = this.this$0.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"contentResolver");
            return new AlbumPresenter(view, new AlbumRepositoryImpl(new ImageDataSourceImpl(contentResolver), new FishBunDataSourceImpl(Fishton.INSTANCE), new CameraDataSourceImpl((Context)this.this$0)), new MainUiHandler());
        }
    }));
    @Nullable
    private Group groupEmptyView;
    @Nullable
    private RecyclerView recyclerAlbumList;
    @Nullable
    private AlbumListAdapter adapter;
    @Nullable
    private TextView txtAlbumMessage;

    private final AlbumContract.Presenter getAlbumPresenter() {
        Lazy lazy = this.albumPresenter$delegate;
        boolean bl = false;
        return (AlbumContract.Presenter)lazy.getValue();
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_album);
        this.initView();
        this.getAlbumPresenter().getDesignViewData();
        if (this.checkPermission()) {
            this.getAlbumPresenter().loadAlbumList();
        }
    }

    protected void onResume() {
        super.onResume();
        this.getAlbumPresenter().onResume();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.getAlbumPresenter().release();
    }

    private final void initView() {
        this.groupEmptyView = (Group)this.findViewById(R.id.group_album_empty);
        this.recyclerAlbumList = (RecyclerView)this.findViewById(R.id.recycler_album_list);
        this.txtAlbumMessage = (TextView)this.findViewById(R.id.txt_album_msg);
        ((ImageView)this.findViewById(R.id.iv_album_camera)).setOnClickListener(arg_0 -> AlbumActivity.initView$lambda-0(this, arg_0));
    }

    @Override
    public void setRecyclerView(@NotNull AlbumViewData albumViewData) {
        Intrinsics.checkNotNullParameter((Object)albumViewData, (String)"albumViewData");
        GridLayoutManager layoutManager = UiUtil.isLandscape((Context)this) ? new GridLayoutManager((Context)this, albumViewData.getAlbumLandscapeSpanCount()) : new GridLayoutManager((Context)this, albumViewData.getAlbumPortraitSpanCount());
        RecyclerView recyclerView = this.recyclerAlbumList;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        }
    }

    @Override
    public void setToolBar(@NotNull AlbumViewData albumViewData) {
        Intrinsics.checkNotNullParameter((Object)albumViewData, (String)"albumViewData");
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_album_bar);
        TextView textView = this.txtAlbumMessage;
        if (textView != null) {
            textView.setText(R.string.msg_loading_image);
        }
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(albumViewData.getColorActionBar());
        toolbar.setTitleTextColor(albumViewData.getColorActionBarTitle());
        if (Build.VERSION.SDK_INT >= 21) {
            UiUtil.setStatusBarColor((Activity)this, albumViewData.getColorStatusBar());
        }
        if ((textView = this.getSupportActionBar()) != null) {
            TextView textView2 = textView;
            boolean bl = false;
            boolean bl2 = false;
            TextView it = textView2;
            boolean bl3 = false;
            it.setTitle((CharSequence)albumViewData.getTitleActionBar());
            it.setDisplayHomeAsUpEnabled(true);
            if (albumViewData.getDrawableHomeAsUpIndicator() != null) {
                it.setHomeAsUpIndicator(albumViewData.getDrawableHomeAsUpIndicator());
            }
        }
        if (albumViewData.isStatusBarLight() && Build.VERSION.SDK_INT >= 23) {
            toolbar.setSystemUiVisibility(8192);
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        this.getAlbumPresenter().getAlbumMenuViewData((Function1<? super AlbumMenuViewData, Unit>)((Function1)new Function1<AlbumMenuViewData, Unit>(this, menu){
            final /* synthetic */ AlbumActivity this$0;
            final /* synthetic */ Menu $menu;
            {
                this.this$0 = $receiver;
                this.$menu = $menu;
                super(1);
            }

            public final void invoke(@NotNull AlbumMenuViewData albumMenuViewData) {
                Intrinsics.checkNotNullParameter((Object)albumMenuViewData, (String)"albumMenuViewData");
                if (albumMenuViewData.getHasButtonInAlbumActivity()) {
                    this.this$0.getMenuInflater().inflate(R.menu.menu_photo_album, this.$menu);
                    MenuItem menuDoneItem = this.$menu.findItem(R.id.action_done);
                    this.$menu.findItem(R.id.action_all_done).setVisible(false);
                    if (albumMenuViewData.getDrawableDoneButton() != null) {
                        menuDoneItem.setIcon(albumMenuViewData.getDrawableDoneButton());
                    } else if (albumMenuViewData.getStrDoneMenu() != null) {
                        if (albumMenuViewData.getColorTextMenu() != Integer.MAX_VALUE) {
                            SpannableString spanString = new SpannableString((CharSequence)albumMenuViewData.getStrDoneMenu());
                            spanString.setSpan((Object)new ForegroundColorSpan(albumMenuViewData.getColorTextMenu()), 0, spanString.length(), 0);
                            menuDoneItem.setTitle((CharSequence)spanString);
                        } else {
                            menuDoneItem.setTitle((CharSequence)albumMenuViewData.getStrDoneMenu());
                        }
                        menuDoneItem.setIcon(null);
                    }
                }
            }
        }));
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
        } else if (id2 == R.id.action_done && this.adapter != null) {
            this.getAlbumPresenter().onClickMenuDone();
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int n = requestCode;
        switch (n) {
            case 129: {
                switch (resultCode) {
                    case -1: {
                        this.getAlbumPresenter().finish();
                        break;
                    }
                    case 29: {
                        this.getAlbumPresenter().loadAlbumList();
                    }
                }
                break;
            }
            case 128: {
                if (resultCode == -1) {
                    this.getAlbumPresenter().onSuccessTakePicture();
                    break;
                }
                String string2 = this.getCameraUtil().getSavedPath();
                if (string2 == null) break;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                new File(it).delete();
            }
        }
    }

    @Override
    public void scanAndRefresh() {
        String string2 = this.getCameraUtil().getSavedPath();
        if (string2 == null) {
            return;
        }
        String savedPath = string2;
        new SingleMediaScanner((Context)this, new File(savedPath), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AlbumActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AlbumActivity.access$getAlbumPresenter(this.this$0).loadAlbumList();
            }
        }));
    }

    @Override
    public void showNothingSelectedMessage(@NotNull String nothingSelectedMessage) {
        Intrinsics.checkNotNullParameter((Object)nothingSelectedMessage, (String)"nothingSelectedMessage");
        RecyclerView recyclerView = this.recyclerAlbumList;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView it = recyclerView2;
            boolean bl3 = false;
            it.post(() -> AlbumActivity.showNothingSelectedMessage$lambda-4$lambda-3(it, nothingSelectedMessage));
        }
    }

    @Override
    public void showMinimumImageMessage(int currentSelectedCount) {
        RecyclerView recyclerView = this.recyclerAlbumList;
        if (recyclerView != null) {
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView it = recyclerView2;
            boolean bl3 = false;
            it.post(() -> AlbumActivity.showMinimumImageMessage$lambda-6$lambda-5(it, this, currentSelectedCount));
        }
    }

    @Override
    public void takePicture(@NotNull String saveDir) {
        Intrinsics.checkNotNullParameter((Object)saveDir, (String)"saveDir");
        if (this.checkCameraPermission()) {
            this.getCameraUtil().takePicture((Activity)this, saveDir, 128);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int n = requestCode;
        switch (n) {
            case 28: {
                int[] nArray = grantResults;
                boolean bl = false;
                int[] nArray2 = nArray;
                boolean bl2 = false;
                if (!(!(nArray2.length == 0))) break;
                if (grantResults[0] == 0) {
                    this.getAlbumPresenter().loadAlbumList();
                    break;
                }
                this.getPermissionCheck().showPermissionDialog();
                this.finish();
                break;
            }
            case 29: {
                int[] nArray = grantResults;
                boolean bl = false;
                int[] nArray3 = nArray;
                boolean bl3 = false;
                if (!(!(nArray3.length == 0))) break;
                if (grantResults[0] == 0) {
                    this.getAlbumPresenter().takePicture();
                    break;
                }
                this.getPermissionCheck().showPermissionDialog();
            }
        }
    }

    @Override
    public void showAlbumList(@NotNull List<Album> albumList, @NotNull ImageAdapter imageAdapter, @NotNull AlbumViewData albumViewData) {
        Intrinsics.checkNotNullParameter(albumList, (String)"albumList");
        Intrinsics.checkNotNullParameter((Object)imageAdapter, (String)"imageAdapter");
        Intrinsics.checkNotNullParameter((Object)albumViewData, (String)"albumViewData");
        RecyclerView recyclerView = this.recyclerAlbumList;
        if (recyclerView != null) {
            recyclerView.setVisibility(0);
        }
        recyclerView = this.groupEmptyView;
        if (recyclerView != null) {
            recyclerView.setVisibility(8);
        }
        this.setAlbumListAdapter(albumList, imageAdapter, albumViewData);
    }

    @Override
    public void onAlbumClick(int position, @NotNull Album album) {
        Intrinsics.checkNotNullParameter((Object)album, (String)"album");
        Intent intent = PickerActivity.Companion.getPickerActivityIntent((Context)this, album.getId(), album.getDisplayName(), position);
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        this.startActivityForResult(it, 129);
    }

    @Override
    public void changeToolbarTitle(int selectedImageCount, @NotNull AlbumViewData albumViewData) {
        Intrinsics.checkNotNullParameter((Object)albumViewData, (String)"albumViewData");
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            CharSequence charSequence;
            ActionBar actionBar2 = actionBar;
            boolean bl = false;
            boolean bl2 = false;
            ActionBar $this$changeToolbarTitle_u24lambda_u2d8 = actionBar2;
            boolean bl3 = false;
            if (albumViewData.getMaxCount() == 1 || !albumViewData.isShowCount()) {
                charSequence = albumViewData.getTitleActionBar();
            } else {
                Object[] objectArray = new Object[]{albumViewData.getTitleActionBar(), selectedImageCount, albumViewData.getMaxCount()};
                charSequence = this.getString(R.string.title_toolbar, objectArray);
            }
            $this$changeToolbarTitle_u24lambda_u2d8.setTitle(charSequence);
        }
    }

    @Override
    public void finishActivityWithResult(@NotNull List<? extends Uri> selectedImages) {
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        Intent i = new Intent();
        i.putParcelableArrayListExtra("intent_path", new ArrayList(selectedImages));
        this.setResult(-1, i);
        this.finish();
    }

    private final boolean checkPermission() {
        return Build.VERSION.SDK_INT >= 23 ? this.getPermissionCheck().checkStoragePermission(28) : true;
    }

    private final boolean checkCameraPermission() {
        return Build.VERSION.SDK_INT >= 23 ? this.getPermissionCheck().checkCameraPermission(29) : true;
    }

    @Override
    public void setRecyclerViewSpanCount(@NotNull AlbumViewData albumViewData) {
        GridLayoutManager gridLayoutManager;
        Intrinsics.checkNotNullParameter((Object)albumViewData, (String)"albumViewData");
        RecyclerView recyclerView = this.recyclerAlbumList;
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        RecyclerView.LayoutManager layoutManager = recyclerView2.getLayoutManager();
        GridLayoutManager gridLayoutManager2 = gridLayoutManager = layoutManager instanceof GridLayoutManager ? (GridLayoutManager)layoutManager : null;
        if (gridLayoutManager == null) {
            return;
        }
        GridLayoutManager gridLayoutManager3 = gridLayoutManager;
        gridLayoutManager3.setSpanCount(UiUtil.isLandscape((Context)this) ? albumViewData.getAlbumLandscapeSpanCount() : albumViewData.getAlbumPortraitSpanCount());
    }

    @Override
    public void refreshAlbumItem(int position, @NotNull ArrayList<Uri> imagePath) {
        Intrinsics.checkNotNullParameter(imagePath, (String)"imagePath");
        String string2 = imagePath.get(imagePath.size() - 1).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"imagePath[imagePath.size - 1].toString()");
        String thumbnailPath = string2;
        int addedCount = imagePath.size();
        AlbumListAdapter albumListAdapter = this.adapter;
        if (albumListAdapter != null) {
            albumListAdapter.updateAlbumMeta(0, addedCount, thumbnailPath);
        }
        albumListAdapter = this.adapter;
        if (albumListAdapter != null) {
            albumListAdapter.updateAlbumMeta(position, addedCount, thumbnailPath);
        }
    }

    @Override
    public void saveImageForAndroidQOrHigher() {
        String string2 = this.getCameraUtil().getSavedPath();
        if (string2 == null) {
            return;
        }
        String savedPath = string2;
        if (Build.VERSION.SDK_INT >= 29) {
            CameraUtil cameraUtil2 = this.getCameraUtil();
            string2 = this.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contentResolver");
            cameraUtil2.saveImageForAndroidQOrHigher((ContentResolver)string2, new File(savedPath));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setAlbumListAdapter(List<Album> albumList, ImageAdapter imageAdapter, AlbumViewData albumViewData) {
        boolean bl;
        AlbumListAdapter albumListAdapter;
        if (this.adapter == null) {
            albumListAdapter = new AlbumListAdapter(this, albumViewData.getAlbumThumbnailSize(), imageAdapter);
            boolean bl2 = false;
            bl = false;
            AlbumListAdapter albumListAdapter2 = albumListAdapter;
            AlbumActivity albumActivity = this;
            boolean bl3 = false;
            RecyclerView recyclerView = this.recyclerAlbumList;
            if (recyclerView != null) {
                void it;
                recyclerView.setAdapter((RecyclerView.Adapter)it);
            }
            Unit unit = Unit.INSTANCE;
            albumActivity.adapter = albumListAdapter;
        }
        if ((albumListAdapter = this.adapter) != null) {
            AlbumListAdapter albumListAdapter3 = albumListAdapter;
            bl = false;
            boolean bl4 = false;
            AlbumListAdapter it = albumListAdapter3;
            boolean bl5 = false;
            it.setAlbumList(albumList);
            it.notifyDataSetChanged();
        }
    }

    @Override
    public void showEmptyView() {
        Group group = this.groupEmptyView;
        if (group != null) {
            group.setVisibility(0);
        }
        group = this.recyclerAlbumList;
        if (group != null) {
            group.setVisibility(4);
        }
        group = this.txtAlbumMessage;
        if (group != null) {
            group.setText(R.string.msg_no_image);
        }
    }

    private static final void initView$lambda-0(AlbumActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getAlbumPresenter().takePicture();
    }

    private static final void showNothingSelectedMessage$lambda-4$lambda-3(RecyclerView $it, String $nothingSelectedMessage) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$nothingSelectedMessage, (String)"$nothingSelectedMessage");
        Snackbar.make((View)((View)$it), (CharSequence)$nothingSelectedMessage, (int)-1).show();
    }

    private static final void showMinimumImageMessage$lambda-6$lambda-5(RecyclerView $it, AlbumActivity this$0, int $currentSelectedCount) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{$currentSelectedCount};
        Snackbar.make((View)((View)$it), (CharSequence)this$0.getString(R.string.msg_minimum_image, objectArray), (int)-1).show();
    }

    public static final /* synthetic */ AlbumContract.Presenter access$getAlbumPresenter(AlbumActivity $this) {
        return $this.getAlbumPresenter();
    }
}

